/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.configuration.Config;
import org.neo4j.gis.spatial.index.Envelope;
import org.neo4j.kernel.impl.index.schema.config.CrsConfig;
import org.neo4j.values.storable.CoordinateReferenceSystem;

class EnvelopeSettings {
    private static final double DEFAULT_MIN_EXTENT = -1000000.0;
    private static final double DEFAULT_MAX_EXTENT = 1000000.0;
    private static final double DEFAULT_MIN_LATITUDE = -90.0;
    private static final double DEFAULT_MAX_LATITUDE = 90.0;
    private static final double DEFAULT_MIN_LONGITUDE = -180.0;
    private static final double DEFAULT_MAX_LONGITUDE = 180.0;
    private final CoordinateReferenceSystem crs;
    private Double[] min;
    private Double[] max;

    EnvelopeSettings(CoordinateReferenceSystem crs) {
        this.crs = crs;
        this.min = new Double[crs.getDimension()];
        this.max = new Double[crs.getDimension()];
        Arrays.fill((Object[])this.min, (Object)Double.NaN);
        Arrays.fill((Object[])this.max, (Object)Double.NaN);
    }

    static Map<CoordinateReferenceSystem, EnvelopeSettings> envelopeSettingsFromConfig(Config config) {
        HashMap<CoordinateReferenceSystem, EnvelopeSettings> env = new HashMap<CoordinateReferenceSystem, EnvelopeSettings>();
        config.getGroups(CrsConfig.class).forEach((id, crsConfig) -> {
            EnvelopeSettings envelopeSettings = new EnvelopeSettings(crsConfig.crs);
            envelopeSettings.min = (Double[])((List)config.get(crsConfig.min)).toArray(Double[]::new);
            envelopeSettings.max = (Double[])((List)config.get(crsConfig.max)).toArray(Double[]::new);
            env.put(crsConfig.crs, envelopeSettings);
        });
        return env;
    }

    Envelope asEnvelope() {
        int dimension = this.crs.getDimension();
        assert (dimension >= 2);
        double[] min = new double[dimension];
        double[] max = new double[dimension];
        int cartesianStartIndex = 0;
        if (this.crs.isGeographic()) {
            min[0] = this.minOrDefault(0, -180.0);
            max[0] = this.maxOrDefault(0, 180.0);
            min[1] = this.minOrDefault(1, -90.0);
            max[1] = this.maxOrDefault(1, 90.0);
            cartesianStartIndex = 2;
        }
        for (int i = cartesianStartIndex; i < dimension; ++i) {
            min[i] = this.minOrDefault(i, -1000000.0);
            max[i] = this.maxOrDefault(i, 1000000.0);
        }
        return new Envelope(min, max);
    }

    CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    private double minOrDefault(int i, double defVal) {
        return EnvelopeSettings.valOrDefault(this.min[i], defVal);
    }

    private double maxOrDefault(int i, double defVal) {
        return EnvelopeSettings.valOrDefault(this.max[i], defVal);
    }

    private static double valOrDefault(double val, double def) {
        return Double.isNaN(val) ? def : val;
    }
}

