/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;

public class TransactionOrEndPositionLocator
implements LogFile.LogFileVisitor {
    private final long startTransactionId;
    private final LogEntryReader logEntryReader;
    private LogPosition position;

    public TransactionOrEndPositionLocator(long startTransactionId, LogEntryReader logEntryReader) {
        this.startTransactionId = startTransactionId;
        this.logEntryReader = logEntryReader;
    }

    @Override
    public boolean visit(ReadableLogPositionAwareChannel channel) throws IOException {
        LogEntry logEntry;
        LogEntryStart startEntry = null;
        block4: while ((logEntry = this.logEntryReader.readLogEntry(channel)) != null) {
            switch (logEntry.getType()) {
                case 1: {
                    startEntry = (LogEntryStart)logEntry;
                    continue block4;
                }
                case 5: {
                    LogEntryCommit commit = (LogEntryCommit)logEntry;
                    if (commit.getTxId() != this.startTransactionId) continue block4;
                    if (startEntry == null) {
                        throw new IllegalStateException("Commit log entry wasn't proceeded by a start log entry.");
                    }
                    this.position = startEntry.getStartPosition();
                    return false;
                }
            }
        }
        this.position = channel.getCurrentLogPosition();
        return true;
    }

    public LogPosition getLogPosition() throws NoSuchTransactionException {
        if (this.position == null) {
            throw new NoSuchTransactionException(this.startTransactionId);
        }
        return this.position;
    }
}

