/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.map.MutableMap;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.Measurable;
import org.neo4j.memory.MemoryTracker;

public class ProbeTable<K extends Measurable, V extends Measurable>
extends DefaultCloseListenable {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ProbeTable.class);
    private final MemoryTracker scopedMemoryTracker;
    private MutableMap<K, HeapTrackingArrayList<V>> map;

    public static <K extends Measurable, V extends Measurable> ProbeTable<K, V> createProbeTable(MemoryTracker memoryTracker) {
        MemoryTracker scopedMemoryTracker = memoryTracker.getScopedMemoryTracker();
        scopedMemoryTracker.allocateHeap(SHALLOW_SIZE + HeapEstimator.SCOPED_MEMORY_TRACKER_SHALLOW_SIZE);
        return new ProbeTable<K, V>(scopedMemoryTracker);
    }

    private ProbeTable(MemoryTracker scopedMemoryTracker) {
        this.scopedMemoryTracker = scopedMemoryTracker;
        this.map = HeapTrackingCollections.newMap((MemoryTracker)scopedMemoryTracker);
    }

    public void put(K key, V value) {
        ((HeapTrackingArrayList)this.map.getIfAbsentPutWith(key, (Function & Serializable)p -> {
            p.allocateHeap(key.estimatedHeapUsage());
            return HeapTrackingCollections.newArrayList((MemoryTracker)p);
        }, (Object)this.scopedMemoryTracker)).add(value);
        this.scopedMemoryTracker.allocateHeap(value.estimatedHeapUsage());
    }

    public Iterator<V> get(K key) {
        HeapTrackingArrayList entry = (HeapTrackingArrayList)this.map.get(key);
        if (entry == null) {
            return Collections.emptyIterator();
        }
        return entry.iterator();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public void closeInternal() {
        if (this.map != null) {
            this.map = null;
            this.scopedMemoryTracker.close();
        }
    }

    public boolean isClosed() {
        return this.map == null;
    }
}

