/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;

class TicketMachine {
    private final AtomicLong currentTicketId = new AtomicLong();

    TicketMachine() {
    }

    Ticket newTicket() {
        return new Ticket(this.currentTicketId::get);
    }

    Barrier nextBarrier() {
        return new Barrier(this.currentTicketId.incrementAndGet());
    }

    static class Ticket {
        private final LongSupplier ticketIdSupplier;
        private volatile long ticketId;

        private Ticket(LongSupplier ticketIdSupplier) {
            this.ticketIdSupplier = ticketIdSupplier;
        }

        void use() {
            this.ticketId = this.ticketIdSupplier.getAsLong();
        }
    }

    record Barrier(long barrier) {
        static final Barrier NO_BARRIER = new Barrier(Long.MAX_VALUE);

        boolean canPass(Ticket ticket) {
            return ticket.ticketId < this.barrier;
        }
    }
}

