/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.procedure;

import java.util.Arrays;
import java.util.Optional;
import org.neo4j.collection.RawIterator;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.kernel.api.ResourceMonitor;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

public interface CallableProcedure {
    public ProcedureSignature signature();

    public RawIterator<AnyValue[], ProcedureException> apply(Context var1, AnyValue[] var2, ResourceMonitor var3) throws ProcedureException;

    public static abstract class BasicProcedure
    implements CallableProcedure {
        private final ProcedureSignature signature;

        protected BasicProcedure(ProcedureSignature signature) {
            this.signature = signature;
        }

        @Override
        public ProcedureSignature signature() {
            return this.signature;
        }

        @Override
        public abstract RawIterator<AnyValue[], ProcedureException> apply(Context var1, AnyValue[] var2, ResourceMonitor var3) throws ProcedureException;

        protected static <T extends AnyValue> Optional<T> getOptionalParameter(int parameterIndex, Class<T> parameterClass, String parameterName, AnyValue[] input) throws ProcedureException {
            try {
                BasicProcedure.checkRange(input, parameterIndex);
            }
            catch (IllegalArgumentException e) {
                return Optional.empty();
            }
            AnyValue value = input[parameterIndex];
            if (value == Values.NO_VALUE) {
                return Optional.empty();
            }
            BasicProcedure.checkType(parameterClass, parameterName, value);
            return Optional.of((AnyValue)parameterClass.cast(value));
        }

        protected static <T extends AnyValue> T getParameter(int parameterIndex, Class<T> parameterClass, String parameterName, AnyValue[] input) throws ProcedureException {
            BasicProcedure.checkRange(input, parameterIndex);
            AnyValue value = input[parameterIndex];
            BasicProcedure.checkType(parameterClass, parameterName, value);
            return (T)((AnyValue)parameterClass.cast(value));
        }

        private static void checkRange(AnyValue[] input, int parameterIndex) {
            if (input.length == 0) {
                throw new IllegalArgumentException("Illegal input:" + Arrays.toString(input));
            }
            if (parameterIndex < 0 || parameterIndex >= input.length) {
                throw new IllegalArgumentException("Input should contains " + (parameterIndex + 1) + " parameters");
            }
        }

        private static <T> void checkType(Class<T> parameterClass, String parameterName, AnyValue value) {
            if (!parameterClass.isInstance(value)) {
                throw new IllegalArgumentException(String.format("Parameter '%s' should have a '%s' representation. Instead it was '%s'", parameterName, parameterClass.getSimpleName(), value.getTypeName()));
            }
        }
    }
}

