/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.IncompleteConstraintValidationException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.stats.IndexUsageStatsConsumer;
import org.neo4j.values.storable.Value;

public abstract class AbstractDelegatingIndexProxy
implements IndexProxy {
    public abstract IndexProxy getDelegate();

    @Override
    public void start() {
        this.getDelegate().start();
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode, CursorContext cursorContext, boolean parallel) {
        return this.getDelegate().newUpdater(mode, cursorContext, parallel);
    }

    public void drop() {
        this.getDelegate().drop();
    }

    @Override
    public InternalIndexState getState() {
        return this.getDelegate().getState();
    }

    @Override
    public IndexDescriptor getDescriptor() {
        return this.getDelegate().getDescriptor();
    }

    @Override
    public void force(FileFlushEvent flushEvent, CursorContext cursorContext) throws IOException {
        this.getDelegate().force(flushEvent, cursorContext);
    }

    @Override
    public void refresh() throws IOException {
        this.getDelegate().refresh();
    }

    @Override
    public void close(CursorContext cursorContext) throws IOException {
        this.getDelegate().close(cursorContext);
    }

    @Override
    public ValueIndexReader newValueReader() throws IndexNotFoundKernelException {
        return this.getDelegate().newValueReader();
    }

    @Override
    public TokenIndexReader newTokenReader() throws IndexNotFoundKernelException {
        return this.getDelegate().newTokenReader();
    }

    @Override
    public boolean awaitStoreScanCompleted(long time, TimeUnit unit) throws IndexPopulationFailedKernelException, InterruptedException {
        return this.getDelegate().awaitStoreScanCompleted(time, unit);
    }

    @Override
    public void activate() {
        this.getDelegate().activate();
    }

    @Override
    public void validate() throws IndexPopulationFailedKernelException, IncompleteConstraintValidationException {
        this.getDelegate().validate();
    }

    @Override
    public void validateBeforeCommit(Value[] tuple, long entityId) {
        this.getDelegate().validateBeforeCommit(tuple, entityId);
    }

    @Override
    public IndexPopulationFailure getPopulationFailure() throws IllegalStateException {
        return this.getDelegate().getPopulationFailure();
    }

    @Override
    public PopulationProgress getIndexPopulationProgress() {
        return this.getDelegate().getIndexPopulationProgress();
    }

    public String toString() {
        return String.format("%s -> %s", this.getClass().getSimpleName(), this.getDelegate());
    }

    public ResourceIterator<Path> snapshotFiles() throws IOException {
        return this.getDelegate().snapshotFiles();
    }

    public Map<String, Value> indexConfig() {
        return this.getDelegate().indexConfig();
    }

    @Override
    public void reportUsageStatistics(IndexUsageStatsConsumer consumer) {
        this.getDelegate().reportUsageStatistics(consumer);
    }

    @Override
    public void maintenance() {
        this.getDelegate().maintenance();
    }
}

