/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.io.pagecache.PageCursor;

public class PointKeyUtil {
    static final int SIZE_GEOMETRY_COORDINATE = 8;
    static final int SIZE_GEOMETRY_HEADER = 3;
    static final int SIZE_GEOMETRY_DERIVED_SPACE_FILLING_CURVE_VALUE = 8;
    private static final int MASK_CODE = 262143;
    private static final int MASK_DIMENSIONS_READ = 0x1C0000;
    private static final int MASK_TABLE_READ = 0xC00000;
    private static final int SHIFT_DIMENSIONS = Integer.bitCount(262143);
    private static final int SHIFT_TABLE = SHIFT_DIMENSIONS + 1 + Integer.bitCount(0x1C0000);
    private static final int MASK_TABLE_PUT = 0xC00000 >>> SHIFT_TABLE;
    private static final int MASK_DIMENSIONS_PUT = 0x1C0000 >>> SHIFT_DIMENSIONS;

    static void writeHeader(PageCursor cursor, long crsTableId, long crsCode, long dimensions) {
        PointKeyUtil.assertValueWithin(crsTableId, MASK_TABLE_PUT, "tableId");
        PointKeyUtil.assertValueWithin(crsCode, 262143, "code");
        PointKeyUtil.assertValueWithin(dimensions, MASK_DIMENSIONS_PUT, "dimensions");
        int header = (int)(crsTableId << SHIFT_TABLE | dimensions << SHIFT_DIMENSIONS | crsCode);
        PointKeyUtil.put3BInt(cursor, header);
    }

    static int readHeader(PageCursor cursor) {
        return PointKeyUtil.read3BInt(cursor);
    }

    static int crsTableId(int header) {
        return (header & 0xC00000) >>> SHIFT_TABLE;
    }

    static int crsCode(int header) {
        return header & 0x3FFFF;
    }

    static int dimensions(int header) {
        return (header & 0x1C0000) >>> SHIFT_DIMENSIONS;
    }

    private static int read3BInt(PageCursor cursor) {
        int low = cursor.getShort() & 0xFFFF;
        int high = cursor.getByte() & 0xFF;
        return high << 16 | low;
    }

    private static void put3BInt(PageCursor cursor, int value) {
        cursor.putShort((short)value);
        cursor.putByte((byte)(value >>> 16));
    }

    private static void assertValueWithin(long value, int maskAllowed, String name) {
        if ((value & (long)(~maskAllowed)) != 0L) {
            throw new IllegalArgumentException("Expected 0 < " + name + " <= " + maskAllowed + ", but was " + value);
        }
    }
}

