/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.reverse;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatch;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.CommittedCommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.IncompleteLogHeaderException;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;

public final class ForwardCommandBatchCursor
implements CommandBatchCursor {
    private final LogFile logFile;
    private final LogEntryReader reader;
    private LogPosition beginning;
    private final FileSystemAbstraction fs;
    private long nextVersion;
    private CommandBatchCursor currentLogCommandBatchCursor;
    private LogPosition lastReasonableLogPosition;

    public ForwardCommandBatchCursor(LogFile logFile, LogPosition beginning, LogEntryReader reader, FileSystemAbstraction fs) throws IOException {
        this.logFile = logFile;
        this.reader = reader;
        this.beginning = beginning;
        this.fs = fs;
        this.currentLogCommandBatchCursor = new CommittedCommandBatchCursor((ReadableLogPositionAwareChannel)logFile.getReader(beginning, LogVersionBridge.NO_MORE_CHANNELS), reader);
        this.lastReasonableLogPosition = this.currentLogCommandBatchCursor.position();
        this.nextVersion = beginning.getLogVersion() + 1L;
    }

    private CommandBatchCursor internalNext() {
        try {
            ReadableLogChannel logChannel;
            try {
                this.beginning = this.getCursorStartPosition();
                logChannel = this.logFile.getReader(this.beginning, LogVersionBridge.NO_MORE_CHANNELS);
            }
            catch (NoSuchFileException | IncompleteLogHeaderException e) {
                return this.currentLogCommandBatchCursor;
            }
            CommittedCommandBatchCursor cursor = new CommittedCommandBatchCursor((ReadableLogPositionAwareChannel)logChannel, this.reader);
            ++this.nextVersion;
            return cursor;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean next() throws IOException {
        while (!this.currentLogCommandBatchCursor.next()) {
            if (this.currentLogCommandBatchCursor.position().getByteOffset() != this.fs.getFileSize(this.logFile.getLogFileForVersion(this.nextVersion - 1L))) {
                return false;
            }
            CommandBatchCursor cursor = this.internalNext();
            if (cursor == this.currentLogCommandBatchCursor) {
                return false;
            }
            this.lastReasonableLogPosition = this.currentLogCommandBatchCursor != null ? this.currentLogCommandBatchCursor.position() : this.beginning;
            this.closeCurrent();
            this.currentLogCommandBatchCursor = cursor;
        }
        return true;
    }

    public void close() throws IOException {
        this.closeCurrent();
    }

    private void closeCurrent() throws IOException {
        if (this.currentLogCommandBatchCursor != null) {
            this.currentLogCommandBatchCursor.close();
            this.currentLogCommandBatchCursor = null;
        }
    }

    private LogPosition getCursorStartPosition() throws IOException {
        LogHeader logHeader = this.logFile.extractHeader(this.nextVersion);
        return logHeader != null ? logHeader.getStartPosition() : new LogPosition(this.nextVersion, 0L);
    }

    @Override
    public LogPosition position() {
        if (this.beginning.equals((Object)this.currentLogCommandBatchCursor.position())) {
            return this.lastReasonableLogPosition;
        }
        return this.currentLogCommandBatchCursor.position();
    }

    public CommittedCommandBatch get() {
        return (CommittedCommandBatch)this.currentLogCommandBatchCursor.get();
    }
}

