/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.watcher;

import java.nio.file.Path;
import java.nio.file.WatchKey;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.neo4j.io.fs.watcher.FileWatchEventListener;
import org.neo4j.io.fs.watcher.resource.WatchedResource;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.internal.LogService;

public class DefaultFileDeletionEventListener
implements FileWatchEventListener {
    private final DatabaseLayout databaseLayout;
    private final Set<WatchedResource> watchedResources;
    private final InternalLog internalLog;
    private final Predicate<String> fileNameFilter;

    DefaultFileDeletionEventListener(DatabaseLayout databaseLayout, Set<WatchedResource> watchedResources, LogService logService, Predicate<String> fileNameFilter) {
        this.databaseLayout = databaseLayout;
        this.watchedResources = watchedResources;
        this.internalLog = logService.getInternalLog(this.getClass());
        this.fileNameFilter = fileNameFilter;
    }

    public void fileDeleted(WatchKey key, String fileName) {
        Optional<WatchedResource> watchedResource;
        if (!this.fileNameFilter.test(fileName) && (watchedResource = this.getListenedResource(key)).isPresent()) {
            Path watchedFile = watchedResource.get().getWatchedFile();
            if (this.isDatabaseDirectory(fileName, watchedFile)) {
                this.printWarning(fileName);
            } else if (this.isFileInDatabaseDirectories(watchedFile)) {
                this.printWarning(fileName);
            }
        }
    }

    private boolean isDatabaseDirectory(String fileName, Path watchedFile) {
        Neo4jLayout neo4jLayout = this.databaseLayout.getNeo4jLayout();
        return fileName.equals(this.databaseLayout.getDatabaseName()) && (neo4jLayout.databasesDirectory().equals(watchedFile) || neo4jLayout.transactionLogsRootDirectory().equals(watchedFile));
    }

    private boolean isFileInDatabaseDirectories(Path watchedFile) {
        return this.databaseLayout.databaseDirectory().equals(watchedFile) || this.databaseLayout.getTransactionLogsDirectory().equals(watchedFile);
    }

    private void printWarning(String fileName) {
        this.internalLog.error("'%s' which belongs to the '%s' database was deleted while it was running.", new Object[]{fileName, this.databaseLayout.getDatabaseName()});
    }

    private Optional<WatchedResource> getListenedResource(WatchKey watchKey) {
        return this.watchedResources.stream().filter(resource -> watchKey.equals(resource.getWatchKey())).findAny();
    }
}

