/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.LogPosition;

public class RecoveryStartInformation {
    static final RecoveryStartInformation NO_RECOVERY_REQUIRED = new RecoveryStartInformation(LogPosition.UNSPECIFIED, null, -1L);
    static final RecoveryStartInformation MISSING_LOGS = new RecoveryStartInformation(null, null, -1L, true);
    private final long firstAppendIndexAfterLastCheckPoint;
    private final LogPosition transactionLogPosition;
    private final CheckpointInfo checkpointInfo;
    private final boolean missingLogs;

    public RecoveryStartInformation(LogPosition transactionLogPosition, CheckpointInfo checkpointInfo, long firstAppendIndexAfterLastCheckPoint) {
        this(transactionLogPosition, checkpointInfo, firstAppendIndexAfterLastCheckPoint, false);
    }

    private RecoveryStartInformation(LogPosition transactionLogPosition, CheckpointInfo checkpointInfo, long firstAppendIndexAfterLastCheckPoint, boolean missingLogs) {
        this.firstAppendIndexAfterLastCheckPoint = firstAppendIndexAfterLastCheckPoint;
        this.transactionLogPosition = transactionLogPosition;
        this.checkpointInfo = checkpointInfo;
        this.missingLogs = missingLogs;
    }

    public boolean isRecoveryRequired() {
        return this.transactionLogPosition != LogPosition.UNSPECIFIED;
    }

    long getFirstAppendIndexAfterLastCheckPoint() {
        return this.firstAppendIndexAfterLastCheckPoint;
    }

    LogPosition getTransactionLogPosition() {
        return this.transactionLogPosition;
    }

    public LogPosition getCheckpointPosition() {
        return this.checkpointInfo != null ? this.checkpointInfo.checkpointEntryPosition() : LogPosition.UNSPECIFIED;
    }

    public CheckpointInfo getCheckpointInfo() {
        return this.checkpointInfo;
    }

    boolean isMissingLogs() {
        return this.missingLogs;
    }
}

