/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.dbms.database.DatabaseStartAbortedException;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatch;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.recovery.CorruptedLogsTruncator;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.kernel.recovery.RecoveryApplier;
import org.neo4j.kernel.recovery.RecoveryMode;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.kernel.recovery.RecoveryPredicate;
import org.neo4j.kernel.recovery.RecoveryPredicateException;
import org.neo4j.kernel.recovery.RecoveryService;
import org.neo4j.kernel.recovery.RecoveryStartInformation;
import org.neo4j.kernel.recovery.RecoveryStartupChecker;
import org.neo4j.kernel.recovery.TransactionIdTracker;
import org.neo4j.storageengine.AppendIndexProvider;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.time.Stopwatch;

public class TransactionLogsRecovery
extends LifecycleAdapter {
    private static final String REVERSE_RECOVERY_TAG = "restoreDatabase";
    private static final String RECOVERY_TAG = "recoverDatabase";
    private static final String RECOVERY_COMPLETED_TAG = "databaseRecoveryCompleted";
    private final RecoveryService recoveryService;
    private final RecoveryMonitor monitor;
    private final CorruptedLogsTruncator logsTruncator;
    private final Lifecycle schemaLife;
    private final ProgressMonitorFactory progressMonitorFactory;
    private final boolean failOnCorruptedLogFiles;
    private final RecoveryStartupChecker recoveryStartupChecker;
    private final boolean rollbackIncompleteTransactions;
    private final CursorContextFactory contextFactory;
    private final RecoveryPredicate recoveryPredicate;
    private final RecoveryMode mode;
    private ProgressListener progressListener;

    public TransactionLogsRecovery(RecoveryService recoveryService, CorruptedLogsTruncator logsTruncator, Lifecycle schemaLife, RecoveryMonitor monitor, ProgressMonitorFactory progressMonitorFactory, boolean failOnCorruptedLogFiles, RecoveryStartupChecker recoveryStartupChecker, RecoveryPredicate recoveryPredicate, boolean rollbackIncompleteTransactions, CursorContextFactory contextFactory, RecoveryMode mode) {
        this.recoveryService = recoveryService;
        this.monitor = monitor;
        this.logsTruncator = logsTruncator;
        this.schemaLife = schemaLife;
        this.progressMonitorFactory = progressMonitorFactory;
        this.failOnCorruptedLogFiles = failOnCorruptedLogFiles;
        this.recoveryStartupChecker = recoveryStartupChecker;
        this.rollbackIncompleteTransactions = rollbackIncompleteTransactions;
        this.contextFactory = contextFactory;
        this.recoveryPredicate = recoveryPredicate;
        this.mode = mode;
        this.progressListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() throws Exception {
        RecoveryRollbackAppendIndexProvider appendIndexProvider;
        CommittedCommandBatch.BatchInformation lastHighestTransactionBatchInfo;
        LogPosition lastTransactionPosition;
        LogPosition recoveryToPosition;
        Stopwatch recoveryStartTime;
        RecoveryStartInformation recoveryStartInformation;
        block50: {
            recoveryStartInformation = this.recoveryService.getRecoveryStartInformation();
            if (!recoveryStartInformation.isRecoveryRequired()) {
                this.schemaLife.init();
                return;
            }
            recoveryStartTime = Stopwatch.start();
            TransactionIdTracker transactionIdTracker = new TransactionIdTracker();
            LogPosition recoveryStartPosition = recoveryStartInformation.getTransactionLogPosition();
            this.monitor.recoveryRequired(recoveryStartPosition);
            recoveryToPosition = recoveryStartPosition;
            lastTransactionPosition = recoveryStartPosition;
            lastHighestTransactionBatchInfo = null;
            CommittedCommandBatch.BatchInformation lastBatchInfo = null;
            appendIndexProvider = null;
            boolean incompleteBatchEncountered = false;
            try {
                if (recoveryStartInformation.isMissingLogs()) break block50;
                try {
                    this.reverseRecovery(recoveryStartInformation, transactionIdTracker, recoveryStartPosition);
                    this.schemaLife.init();
                    boolean fullRecovery = true;
                    try (CommandBatchCursor transactionsToRecover = this.recoveryService.getCommandBatches(recoveryStartPosition);
                         RecoveryApplier recoveryVisitor = this.recoveryService.getRecoveryApplier(TransactionApplicationMode.RECOVERY, this.contextFactory, RECOVERY_TAG);){
                        while (fullRecovery && transactionsToRecover.next()) {
                            CommittedCommandBatch nextCommandBatch = (CommittedCommandBatch)transactionsToRecover.get();
                            if (!this.recoveryPredicate.test(nextCommandBatch)) {
                                this.monitor.partialRecovery(this.recoveryPredicate, lastHighestTransactionBatchInfo);
                                fullRecovery = false;
                                if (lastHighestTransactionBatchInfo != null) continue;
                                long beforeCheckpointAppendIndex = recoveryStartInformation.getFirstAppendIndexAfterLastCheckPoint() - 1L;
                                if (beforeCheckpointAppendIndex < 1L) {
                                    throw new RecoveryPredicateException(String.format("Partial recovery criteria can't be satisfied. No transaction after checkpoint matching to provided criteria found and transaction before checkpoint is not valid. Append index before checkpoint: %d, criteria %s.", beforeCheckpointAppendIndex, this.recoveryPredicate.describe()));
                                }
                                try {
                                    CommandBatchCursor beforeCheckpointCursor = this.recoveryService.getCommandBatches(beforeCheckpointAppendIndex);
                                    try {
                                        if (beforeCheckpointCursor.next()) {
                                            CommittedCommandBatch candidate = (CommittedCommandBatch)beforeCheckpointCursor.get();
                                            if (!this.recoveryPredicate.test(candidate)) {
                                                throw new RecoveryPredicateException(String.format("Partial recovery criteria can't be satisfied. Transaction after and before checkpoint does not satisfy provided recovery criteria. Observed transaction id: %d, recovery criteria: %s.", candidate.txId(), this.recoveryPredicate.describe()));
                                            }
                                            lastHighestTransactionBatchInfo = candidate.batchInformation();
                                            lastTransactionPosition = beforeCheckpointCursor.position();
                                            continue;
                                        }
                                        throw new RecoveryPredicateException(String.format("Partial recovery criteria can't be satisfied. No transaction after checkpoint matching to provided criteria found and transaction before checkpoint not found. Recovery criteria: %s.", this.recoveryPredicate.describe()));
                                    }
                                    finally {
                                        if (beforeCheckpointCursor == null) continue;
                                        beforeCheckpointCursor.close();
                                        continue;
                                    }
                                }
                                catch (RecoveryPredicateException re) {
                                    throw re;
                                }
                                catch (Exception e) {
                                    throw new RecoveryPredicateException(String.format("Partial recovery criteria can't be satisfied. No transaction after checkpoint matching to provided criteria found and fail to read transaction before checkpoint. Recovery criteria: %s.", this.recoveryPredicate.describe()), e);
                                }
                            }
                            this.recoveryStartupChecker.checkIfCanceled();
                            switch (transactionIdTracker.transactionStatus(nextCommandBatch.txId())) {
                                case RECOVERABLE: {
                                    recoveryVisitor.visit(nextCommandBatch);
                                    this.monitor.batchRecovered(nextCommandBatch);
                                    break;
                                }
                                case ROLLED_BACK: {
                                    this.monitor.batchApplySkipped(nextCommandBatch);
                                    break;
                                }
                                case INCOMPLETE: {
                                    this.monitor.batchApplySkipped(nextCommandBatch);
                                    if (this.rollbackIncompleteTransactions) break;
                                    if (lastHighestTransactionBatchInfo == null) {
                                        CheckpointInfo checkpointInfo = recoveryStartInformation.getCheckpointInfo();
                                        TransactionId transactionId = checkpointInfo.transactionId();
                                        lastBatchInfo = new CommittedCommandBatch.BatchInformation(transactionId, checkpointInfo.appendIndex());
                                        lastHighestTransactionBatchInfo = new CommittedCommandBatch.BatchInformation(transactionId, transactionId.appendIndex());
                                    }
                                    fullRecovery = false;
                                    incompleteBatchEncountered = true;
                                    break;
                                }
                            }
                            if (!incompleteBatchEncountered) {
                                if (lastHighestTransactionBatchInfo == null || lastHighestTransactionBatchInfo.txId() < nextCommandBatch.txId()) {
                                    lastHighestTransactionBatchInfo = nextCommandBatch.batchInformation();
                                }
                                lastBatchInfo = nextCommandBatch.batchInformation();
                                recoveryToPosition = lastTransactionPosition = transactionsToRecover.position();
                            }
                            this.reportProgress();
                        }
                        recoveryToPosition = fullRecovery ? transactionsToRecover.position() : lastTransactionPosition;
                    }
                }
                catch (Error | ClosedByInterruptException | DatabaseStartAbortedException | RecoveryPredicateException e) {
                    throw e;
                }
                catch (Throwable t) {
                    if (this.failOnCorruptedLogFiles) {
                        Recovery.throwUnableToCleanRecover(t);
                    }
                    if (lastHighestTransactionBatchInfo != null) {
                        this.monitor.failToRecoverTransactionsAfterCommit(t, lastHighestTransactionBatchInfo, recoveryToPosition);
                    }
                    this.monitor.failToRecoverTransactionsAfterPosition(t, recoveryStartPosition);
                }
                appendIndexProvider = new RecoveryRollbackAppendIndexProvider(lastBatchInfo);
                if (!this.rollbackIncompleteTransactions) break block50;
                this.logsTruncator.truncate(recoveryToPosition, recoveryStartInformation.getCheckpointInfo());
                RecoveryService.RollbackTransactionInfo rollbackTransactionInfo = this.recoveryService.rollbackTransactions(recoveryToPosition, transactionIdTracker, lastHighestTransactionBatchInfo, appendIndexProvider);
                if (rollbackTransactionInfo != null) {
                    if (lastHighestTransactionBatchInfo == null || lastHighestTransactionBatchInfo.txId() < rollbackTransactionInfo.batchInfo().txId()) {
                        lastHighestTransactionBatchInfo = rollbackTransactionInfo.batchInfo();
                    }
                    lastTransactionPosition = rollbackTransactionInfo.position();
                }
            }
            finally {
                this.closeProgress();
            }
        }
        try (CursorContext cursorContext = this.contextFactory.create(RECOVERY_COMPLETED_TAG);){
            boolean missingLogs = recoveryStartInformation.isMissingLogs();
            this.recoveryService.transactionsRecovered(lastHighestTransactionBatchInfo, appendIndexProvider, lastTransactionPosition, recoveryToPosition, recoveryStartInformation.getCheckpointPosition(), missingLogs, cursorContext);
        }
        this.monitor.recoveryCompleted(recoveryStartTime.elapsed(TimeUnit.MILLISECONDS), this.mode);
    }

    private void reverseRecovery(RecoveryStartInformation recoveryStartInformation, TransactionIdTracker transactionIdTracker, LogPosition recoveryStartPosition) throws Exception {
        if (this.mode == RecoveryMode.FORWARD) {
            this.initProgressReporter(recoveryStartInformation, recoveryStartPosition);
            return;
        }
        CommittedCommandBatch lastReversedCommandBatch = null;
        long lowestRecoveredAppendIndex = recoveryStartInformation.getFirstAppendIndexAfterLastCheckPoint();
        try (CommandBatchCursor transactionsToRecover = this.recoveryService.getCommandBatchesInReverseOrder(recoveryStartPosition);
             RecoveryApplier recoveryVisitor = this.recoveryService.getRecoveryApplier(TransactionApplicationMode.REVERSE_RECOVERY, this.contextFactory, REVERSE_RECOVERY_TAG);){
            while (transactionsToRecover.next()) {
                this.recoveryStartupChecker.checkIfCanceled();
                CommittedCommandBatch commandBatch = (CommittedCommandBatch)transactionsToRecover.get();
                if (lastReversedCommandBatch == null) {
                    lastReversedCommandBatch = commandBatch;
                    this.initProgressReporter(recoveryStartInformation, lastReversedCommandBatch, this.mode);
                }
                recoveryVisitor.visit(commandBatch);
                transactionIdTracker.trackBatch(commandBatch);
                lowestRecoveredAppendIndex = commandBatch.appendIndex();
                this.reportProgress();
            }
        }
        this.monitor.reverseStoreRecoveryCompleted(lowestRecoveredAppendIndex);
    }

    private void initProgressReporter(RecoveryStartInformation recoveryStartInformation, LogPosition recoveryStartPosition) throws IOException {
        try (CommandBatchCursor transactionsToRecover = this.recoveryService.getCommandBatchesInReverseOrder(recoveryStartPosition);){
            if (transactionsToRecover.next()) {
                CommittedCommandBatch commandBatch = (CommittedCommandBatch)transactionsToRecover.get();
                this.initProgressReporter(recoveryStartInformation, commandBatch, this.mode);
            }
        }
    }

    private void initProgressReporter(RecoveryStartInformation recoveryStartInformation, CommittedCommandBatch lastReversedBatch, RecoveryMode mode) {
        long numberOfBatchesToRecover = TransactionLogsRecovery.estimateNumberOfBatchesToRecover(recoveryStartInformation, lastReversedBatch);
        this.progressListener = this.progressMonitorFactory.singlePart("TransactionLogsRecovery", mode == RecoveryMode.FULL ? numberOfBatchesToRecover * 2L : numberOfBatchesToRecover);
    }

    private void reportProgress() {
        this.progressListener.add(1L);
    }

    private void closeProgress() {
        if (this.progressListener != null) {
            this.progressListener.close();
        }
    }

    private static long estimateNumberOfBatchesToRecover(RecoveryStartInformation recoveryStartInformation, CommittedCommandBatch lastReversedCommandBatch) {
        return lastReversedCommandBatch.appendIndex() - recoveryStartInformation.getFirstAppendIndexAfterLastCheckPoint() + 1L;
    }

    public void start() throws Exception {
        this.schemaLife.start();
    }

    public void stop() throws Exception {
        this.schemaLife.stop();
    }

    public void shutdown() throws Exception {
        this.schemaLife.shutdown();
    }

    private static class RecoveryRollbackAppendIndexProvider
    implements AppendIndexProvider {
        private final MutableLong rollbackIndex;

        public RecoveryRollbackAppendIndexProvider(CommittedCommandBatch.BatchInformation lastBatchInfo) {
            this.rollbackIndex = lastBatchInfo == null ? new MutableLong(1L) : new MutableLong(lastBatchInfo.appendIndex());
        }

        public long nextAppendIndex() {
            return this.rollbackIndex.incrementAndGet();
        }

        public long getLastAppendIndex() {
            return this.rollbackIndex.longValue();
        }
    }
}

