/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.layout;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;

public final class Neo4jLayout {
    private static final String STORE_LOCK_FILENAME = "store_lock";
    private static final String SERVER_ID_FILENAME = "server_id";
    private final Path homeDirectory;
    private final Path dataDirectory;
    private final Path databasesRootDirectory;
    private final Path txLogsRootDirectory;
    private final Path scriptRootDirectory;

    public static Neo4jLayout of(Path homeDirectory) {
        return Neo4jLayout.of(Config.defaults((Setting)GraphDatabaseSettings.neo4j_home, (Object)FileUtils.getCanonicalFile((Path)homeDirectory).toAbsolutePath()));
    }

    public static Neo4jLayout of(Config config) {
        Path homeDirectory = (Path)config.get(GraphDatabaseSettings.neo4j_home);
        Path dataDirectory = (Path)config.get(GraphDatabaseSettings.data_directory);
        Path databasesRootDirectory = (Path)config.get(GraphDatabaseInternalSettings.databases_root_path);
        Path txLogsRootDirectory = (Path)config.get(GraphDatabaseSettings.transaction_logs_root_path);
        Path scriptRootDirectory = (Path)config.get(GraphDatabaseSettings.script_root_path);
        return new Neo4jLayout(homeDirectory, dataDirectory, databasesRootDirectory, txLogsRootDirectory, scriptRootDirectory);
    }

    public static Neo4jLayout ofFlat(Path homeDirectory) {
        Path home = homeDirectory.toAbsolutePath();
        Config config = Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)home).set(GraphDatabaseSettings.data_directory, (Object)home).set(GraphDatabaseSettings.transaction_logs_root_path, (Object)home).set(GraphDatabaseInternalSettings.databases_root_path, (Object)home).build();
        return Neo4jLayout.of(config);
    }

    private Neo4jLayout(Path homeDirectory, Path dataDirectory, Path databasesRootDirectory, Path txLogsRootDirectory, Path scriptRootDirectory) {
        this.homeDirectory = FileUtils.getCanonicalFile((Path)homeDirectory);
        this.dataDirectory = FileUtils.getCanonicalFile((Path)dataDirectory);
        this.databasesRootDirectory = FileUtils.getCanonicalFile((Path)databasesRootDirectory);
        this.txLogsRootDirectory = FileUtils.getCanonicalFile((Path)txLogsRootDirectory);
        this.scriptRootDirectory = FileUtils.getCanonicalFile((Path)scriptRootDirectory);
    }

    public Collection<DatabaseLayout> databaseLayouts() {
        Collection collection;
        block9: {
            Stream<Path> list = Files.list(this.databasesRootDirectory);
            try {
                collection = list.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(directory -> DatabaseLayout.of(this, directory.getFileName().toString())).collect(Collectors.toList());
                if (list == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (list != null) {
                        try {
                            list.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    return Collections.emptyList();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            list.close();
        }
        return collection;
    }

    public DatabaseLayout databaseLayout(String databaseName) {
        return DatabaseLayout.of(this, databaseName);
    }

    public Path databasesDirectory() {
        return this.databasesRootDirectory;
    }

    public Path homeDirectory() {
        return this.homeDirectory;
    }

    public Path transactionLogsRootDirectory() {
        return this.txLogsRootDirectory;
    }

    public Path scriptRootDirectory() {
        return this.scriptRootDirectory;
    }

    public Path dataDirectory() {
        return this.dataDirectory;
    }

    public Path storeLockFile() {
        return this.databasesRootDirectory.resolve(STORE_LOCK_FILENAME);
    }

    public Path serverIdFile() {
        return this.dataDirectory.resolve(SERVER_ID_FILENAME);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Neo4jLayout that = (Neo4jLayout)o;
        return Objects.equals(this.homeDirectory, that.homeDirectory) && Objects.equals(this.dataDirectory, that.dataDirectory) && Objects.equals(this.databasesRootDirectory, that.databasesRootDirectory) && Objects.equals(this.txLogsRootDirectory, that.txLogsRootDirectory);
    }

    public int hashCode() {
        return Objects.hash(this.homeDirectory, this.dataDirectory, this.databasesRootDirectory, this.txLogsRootDirectory);
    }

    public String toString() {
        return String.format("Neo4JLayout{ homeDir=%s, dataDir=%s, databasesDir=%s, txLogsRootDir=%s}", this.homeDirectory.toString(), this.dataDirectory.toString(), this.databasesRootDirectory.toString(), this.txLogsRootDirectory.toString());
    }
}

