/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.layout;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.CommonDatabaseFile;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public class DatabaseLayout {
    private static final String DATABASE_LOCK_FILENAME = "database_lock";
    private static final String BACKUP_TOOLS_FOLDER = "tools";
    private static final String QUARANTINE_MARKER_FILENAME = "quarantine_marker";
    private final Path databaseDirectory;
    private final Neo4jLayout neo4jLayout;
    private final String databaseName;

    public static DatabaseLayout ofFlat(Path databaseDirectory) {
        Path canonical = FileUtils.getCanonicalFile((Path)databaseDirectory);
        Path home = canonical.getParent();
        String dbName = canonical.getFileName().toString();
        return Neo4jLayout.ofFlat(home).databaseLayout(dbName);
    }

    public static DatabaseLayout of(Config config) {
        return Neo4jLayout.of(config).databaseLayout((String)config.get(GraphDatabaseSettings.default_database));
    }

    public static DatabaseLayout of(Neo4jLayout neo4jLayout, String databaseName) {
        return new DatabaseLayout(neo4jLayout, databaseName);
    }

    protected DatabaseLayout(Neo4jLayout neo4jLayout, String databaseName) {
        String normalizedName = new NormalizedDatabaseName(databaseName).name();
        this.neo4jLayout = neo4jLayout;
        this.databaseDirectory = FileUtils.getCanonicalFile((Path)neo4jLayout.databasesDirectory().resolve(normalizedName));
        this.databaseName = normalizedName;
    }

    public Path getTransactionLogsDirectory() {
        return this.neo4jLayout.transactionLogsRootDirectory().resolve(this.getDatabaseName());
    }

    public Path getScriptDirectory() {
        return this.neo4jLayout.scriptRootDirectory().resolve(this.getDatabaseName());
    }

    public Path databaseLockFile() {
        return this.databaseDirectory().resolve(DATABASE_LOCK_FILENAME);
    }

    public Path quarantineMarkerFile() {
        return this.databaseDirectory().resolve(QUARANTINE_MARKER_FILENAME);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Neo4jLayout getNeo4jLayout() {
        return this.neo4jLayout;
    }

    public Path databaseDirectory() {
        return this.databaseDirectory;
    }

    public Path backupToolsFolder() {
        return this.databaseDirectory().resolve(BACKUP_TOOLS_FOLDER);
    }

    public Path labelScanStore() {
        return this.file(CommonDatabaseFile.LABEL_SCAN_STORE.getName());
    }

    public Path relationshipTypeScanStore() {
        return this.file(CommonDatabaseFile.RELATIONSHIP_TYPE_SCAN_STORE.getName());
    }

    public Path indexStatisticsStore() {
        return this.file(CommonDatabaseFile.INDEX_STATISTICS_STORE.getName());
    }

    public Path metadataStore() {
        return this.file(CommonDatabaseFile.METADATA_STORE.getName());
    }

    public Set<Path> idFiles() {
        return this.databaseFiles().filter(DatabaseFile::hasIdFile).flatMap(value -> this.idFile((DatabaseFile)value).stream()).collect(Collectors.toSet());
    }

    public Set<Path> storeFiles() {
        return this.databaseFiles().map(this::file).collect(Collectors.toSet());
    }

    protected Stream<DatabaseFile> databaseFiles() {
        throw new IllegalStateException("Can not check database files for a plain DatabaseLayout.");
    }

    public Optional<Path> idFile(DatabaseFile file) {
        return file.hasIdFile() ? Optional.of(this.idFile(file.getName())) : Optional.empty();
    }

    public Path file(String fileName) {
        return this.databaseDirectory.resolve(fileName);
    }

    public Path file(DatabaseFile databaseFile) {
        return this.file(databaseFile.getName());
    }

    public Stream<Path> allFiles(DatabaseFile databaseFile) {
        return Stream.concat(this.idFile(databaseFile).stream(), Stream.of(this.file(databaseFile)));
    }

    public Path[] listDatabaseFiles(Predicate<? super Path> filter) {
        Path[] pathArray;
        block8: {
            Stream<Path> list = Files.list(this.databaseDirectory);
            try {
                pathArray = (Path[])list.filter(filter).toArray(Path[]::new);
                if (list == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (list != null) {
                        try {
                            list.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            list.close();
        }
        return pathArray;
    }

    protected Path idFile(String name) {
        return this.file(DatabaseLayout.idFileName(name));
    }

    private static String idFileName(String storeName) {
        return storeName + ".id";
    }

    public int hashCode() {
        return Objects.hash(this.databaseDirectory, this.neo4jLayout);
    }

    public String toString() {
        return "DatabaseLayout{databaseDirectory=" + String.valueOf(this.databaseDirectory) + ", transactionLogsDirectory=" + String.valueOf(this.getTransactionLogsDirectory()) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseLayout that = (DatabaseLayout)o;
        return Objects.equals(this.databaseDirectory, that.databaseDirectory) && Objects.equals(this.neo4jLayout, that.neo4jLayout) && this.getTransactionLogsDirectory().equals(that.getTransactionLogsDirectory());
    }
}

