/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.index.impl.lucene.legacy.IndexClockCache;
import org.neo4j.index.impl.lucene.legacy.IndexIdentifier;
import org.neo4j.index.impl.lucene.legacy.IndexReference;
import org.neo4j.index.impl.lucene.legacy.IndexReferenceFactory;
import org.neo4j.index.impl.lucene.legacy.IndexType;
import org.neo4j.index.impl.lucene.legacy.IndexTypeCache;
import org.neo4j.index.impl.lucene.legacy.LuceneLegacyIndex;
import org.neo4j.index.impl.lucene.legacy.ReadOnlyIndexReferenceFactory;
import org.neo4j.index.impl.lucene.legacy.WritableIndexReferenceFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class LuceneDataSource
extends LifecycleAdapter {
    public static final Analyzer LOWER_CASE_WHITESPACE_ANALYZER = new Analyzer(){

        protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
            WhitespaceTokenizer source = new WhitespaceTokenizer();
            LowerCaseFilter filter = new LowerCaseFilter((TokenStream)source);
            return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)filter);
        }

        public String toString() {
            return "LOWER_CASE_WHITESPACE_ANALYZER";
        }
    };
    public static final Analyzer WHITESPACE_ANALYZER = new WhitespaceAnalyzer();
    public static final Analyzer KEYWORD_ANALYZER = new KeywordAnalyzer();
    private final File storeDir;
    private final Config config;
    private final FileSystemAbstraction fileSystemAbstraction;
    private final OperationalMode operationalMode;
    private IndexClockCache indexSearchers;
    private File baseStorePath;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    final IndexConfigStore indexStore;
    private IndexTypeCache typeCache;
    private boolean readOnly;
    private boolean closed;
    private LuceneFilesystemFacade filesystemFacade;
    private IndexReferenceFactory indexReferenceFactory;

    public LuceneDataSource(File storeDir, Config config, IndexConfigStore indexStore, FileSystemAbstraction fileSystemAbstraction, OperationalMode operationalMode) {
        this.storeDir = storeDir;
        this.config = config;
        this.indexStore = indexStore;
        this.typeCache = new IndexTypeCache(indexStore);
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.operationalMode = operationalMode;
    }

    public void init() {
        this.filesystemFacade = (Boolean)this.config.get(Configuration.ephemeral) != false ? LuceneFilesystemFacade.MEMORY : LuceneFilesystemFacade.FS;
        this.readOnly = this.isReadOnly(this.config, this.operationalMode);
        this.indexSearchers = new IndexClockCache((Integer)this.config.get(Configuration.lucene_searcher_cache_size));
        this.baseStorePath = this.filesystemFacade.ensureDirectoryExists(this.fileSystemAbstraction, LuceneDataSource.getLuceneIndexStoreDirectory(this.storeDir));
        this.filesystemFacade.cleanWriteLocks(this.baseStorePath);
        this.typeCache = new IndexTypeCache(this.indexStore);
        this.indexReferenceFactory = this.readOnly ? new ReadOnlyIndexReferenceFactory(this.filesystemFacade, this.baseStorePath, this.typeCache) : new WritableIndexReferenceFactory(this.filesystemFacade, this.baseStorePath, this.typeCache);
        this.closed = false;
    }

    public static File getLuceneIndexStoreDirectory(File storeDir) {
        return new File(storeDir, "index");
    }

    IndexType getType(IndexIdentifier identifier, boolean recovery) {
        return this.typeCache.getIndexType(identifier, recovery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws IOException {
        LuceneDataSource luceneDataSource = this;
        synchronized (luceneDataSource) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            for (IndexReference searcher : this.indexSearchers.values()) {
                searcher.dispose();
            }
            this.indexSearchers.clear();
        }
    }

    private synchronized IndexReference[] getAllIndexes() {
        Collection indexReferences = this.indexSearchers.values();
        return indexReferences.toArray(new IndexReference[indexReferences.size()]);
    }

    void force() {
        if (this.readOnly) {
            return;
        }
        for (IndexReference index : this.getAllIndexes()) {
            try {
                index.getWriter().commit();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to commit changes to " + index.getIdentifier(), e);
            }
        }
    }

    void getReadLock() {
        this.lock.readLock().lock();
    }

    void releaseReadLock() {
        this.lock.readLock().unlock();
    }

    void getWriteLock() {
        this.lock.writeLock().lock();
    }

    void releaseWriteLock() {
        this.lock.writeLock().unlock();
    }

    static File getFileDirectory(File storeDir, IndexEntityType type) {
        File path = new File(storeDir, "lucene");
        String extra = type.nameToLowerCase();
        return new File(path, extra);
    }

    static File getFileDirectory(File storeDir, IndexIdentifier identifier) {
        return new File(LuceneDataSource.getFileDirectory(storeDir, identifier.entityType), identifier.indexName);
    }

    static Directory getDirectory(File storeDir, IndexIdentifier identifier) throws IOException {
        return FSDirectory.open((Path)LuceneDataSource.getFileDirectory(storeDir, identifier).toPath());
    }

    static TopFieldCollector scoringCollector(Sort sorting, int n) throws IOException {
        return TopFieldCollector.create((Sort)sorting, (int)n, (boolean)false, (boolean)true, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IndexReference getIndexSearcher(IndexIdentifier identifier) {
        this.assertNotClosed();
        IndexReference searcher = (IndexReference)this.indexSearchers.get(identifier);
        if (searcher == null) {
            return this.syncGetIndexSearcher(identifier);
        }
        IndexReference indexReference = searcher;
        synchronized (indexReference) {
            searcher = (IndexReference)this.indexSearchers.get(identifier);
            if (searcher == null || searcher.isClosed()) {
                return this.syncGetIndexSearcher(identifier);
            }
            searcher = this.refreshSearcherIfNeeded(searcher);
            searcher.incRef();
            return searcher;
        }
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("Lucene index provider has been shut down");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized IndexReference syncGetIndexSearcher(IndexIdentifier identifier) {
        try {
            IndexReference indexReference = (IndexReference)this.indexSearchers.get(identifier);
            if (indexReference == null) {
                indexReference = this.indexReferenceFactory.createIndexReference(identifier);
                this.indexSearchers.put(identifier, indexReference);
            } else if (!this.readOnly) {
                IndexReference indexReference2 = indexReference;
                synchronized (indexReference2) {
                    indexReference = this.refreshSearcherIfNeeded(indexReference);
                }
            }
            indexReference.incRef();
            return indexReference;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private IndexReference refreshSearcherIfNeeded(IndexReference searcher) {
        if (searcher.checkAndClearStale() && (searcher = this.indexReferenceFactory.refresh(searcher)) != null) {
            this.indexSearchers.put(searcher.getIdentifier(), searcher);
        }
        return searcher;
    }

    void invalidateIndexSearcher(IndexIdentifier identifier) {
        IndexReference searcher = (IndexReference)this.indexSearchers.get(identifier);
        if (searcher != null) {
            searcher.setStale();
        }
    }

    void deleteIndex(IndexIdentifier identifier, boolean recovery) throws IOException {
        boolean removeFromIndexStore;
        if (this.readOnly) {
            throw new IllegalStateException("Index deletion in read only mode is not supported.");
        }
        this.closeIndex(identifier);
        FileUtils.deleteRecursively((File)LuceneDataSource.getFileDirectory(this.baseStorePath, identifier));
        boolean bl = removeFromIndexStore = !recovery || this.indexStore.has(identifier.entityType.entityClass(), identifier.indexName);
        if (removeFromIndexStore) {
            this.indexStore.remove(identifier.entityType.entityClass(), identifier.indexName);
        }
        this.typeCache.invalidate(identifier);
    }

    static Document findDocument(IndexType type, IndexSearcher searcher, long entityId) {
        try {
            TopDocs docs = searcher.search(type.idTermQuery(entityId), 1);
            if (docs.scoreDocs.length > 0) {
                return searcher.doc(docs.scoreDocs[0].doc);
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean documentIsEmpty(Document document) {
        List fields = document.getFields();
        for (IndexableField field : fields) {
            if (!LuceneLegacyIndex.isValidKey(field.name())) continue;
            return false;
        }
        return true;
    }

    private synchronized void closeIndex(IndexIdentifier identifier) {
        try {
            IndexReference searcher = (IndexReference)this.indexSearchers.remove(identifier);
            if (searcher != null) {
                searcher.dispose();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to close lucene writer " + identifier, e);
        }
    }

    public ResourceIterator<File> listStoreFiles(boolean includeLogicalLogs) throws IOException {
        final ArrayList<File> files = new ArrayList<File>();
        final ArrayList<Pair> snapshots = new ArrayList<Pair>();
        this.makeSureAllIndexesAreInstantiated();
        for (IndexReference writer : this.getAllIndexes()) {
            IndexCommit commit;
            SnapshotDeletionPolicy deletionPolicy = (SnapshotDeletionPolicy)writer.getWriter().getConfig().getIndexDeletionPolicy();
            File indexDirectory = LuceneDataSource.getFileDirectory(this.baseStorePath, writer.getIdentifier());
            try {
                commit = deletionPolicy.snapshot();
            }
            catch (IllegalStateException e) {
                writer.getWriter().commit();
                commit = deletionPolicy.snapshot();
            }
            for (String fileName : commit.getFileNames()) {
                files.add(new File(indexDirectory, fileName));
            }
            snapshots.add(Pair.of((Object)deletionPolicy, (Object)commit));
        }
        return new PrefetchingResourceIterator<File>(){
            private final Iterator<File> filesIterator;
            {
                this.filesIterator = files.iterator();
            }

            protected File fetchNextOrNull() {
                return this.filesIterator.hasNext() ? this.filesIterator.next() : null;
            }

            public void close() {
                for (Pair policyAndCommit : snapshots) {
                    try {
                        ((SnapshotDeletionPolicy)policyAndCommit.first()).release((IndexCommit)policyAndCommit.other());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
    }

    public ResourceIterator<File> listStoreFiles() throws IOException {
        return this.listStoreFiles(false);
    }

    private void makeSureAllIndexesAreInstantiated() {
        IndexIdentifier identifier;
        Map config;
        for (String name : this.indexStore.getNames(Node.class)) {
            config = this.indexStore.get(Node.class, name);
            if (!((String)config.get("provider")).equals("lucene")) continue;
            identifier = new IndexIdentifier(IndexEntityType.Node, name);
            this.getIndexSearcher(identifier).close();
        }
        for (String name : this.indexStore.getNames(Relationship.class)) {
            config = this.indexStore.get(Relationship.class, name);
            if (!((String)config.get("provider")).equals("lucene")) continue;
            identifier = new IndexIdentifier(IndexEntityType.Relationship, name);
            this.getIndexSearcher(identifier).close();
        }
    }

    private boolean isReadOnly(Config config, OperationalMode operationalMode) {
        return (Boolean)config.get(GraphDatabaseSettings.read_only) != false && OperationalMode.single == operationalMode;
    }

    static enum LuceneFilesystemFacade {
        FS{

            @Override
            Directory getDirectory(File baseStorePath, IndexIdentifier identifier) throws IOException {
                return FSDirectory.open((Path)LuceneDataSource.getFileDirectory(baseStorePath, identifier).toPath());
            }

            @Override
            void cleanWriteLocks(File dir) {
                if (!dir.isDirectory()) {
                    return;
                }
                for (File file : dir.listFiles()) {
                    if (file.isDirectory()) {
                        this.cleanWriteLocks(file);
                        continue;
                    }
                    if (!file.getName().equals("write.lock")) continue;
                    boolean success = file.delete();
                    assert (success);
                }
            }

            @Override
            File ensureDirectoryExists(FileSystemAbstraction fileSystem, File dir) {
                if (!dir.exists() && !dir.mkdirs()) {
                    String message = String.format("Unable to create directory path[%s] for Neo4j store.", dir.getAbsolutePath());
                    throw new RuntimeException(message);
                }
                return dir;
            }
        }
        ,
        MEMORY{

            @Override
            Directory getDirectory(File baseStorePath, IndexIdentifier identifier) {
                return new RAMDirectory();
            }

            @Override
            void cleanWriteLocks(File path) {
            }

            @Override
            File ensureDirectoryExists(FileSystemAbstraction fileSystem, File path) {
                try {
                    fileSystem.mkdirs(path);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return path;
            }
        };


        abstract Directory getDirectory(File var1, IndexIdentifier var2) throws IOException;

        abstract File ensureDirectoryExists(FileSystemAbstraction var1, File var2);

        abstract void cleanWriteLocks(File var1);
    }

    public static abstract class Configuration {
        public static final Setting<Integer> lucene_searcher_cache_size = GraphDatabaseSettings.lucene_searcher_cache_size;
        public static final Setting<Boolean> ephemeral = GraphDatabaseFacadeFactory.Configuration.ephemeral;
    }
}

