/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.neo4j.index.impl.lucene.explicit.IndexIdentifier;
import org.neo4j.index.impl.lucene.explicit.IndexReference;
import org.neo4j.index.impl.lucene.explicit.IndexType;
import org.neo4j.index.impl.lucene.explicit.IndexTypeCache;
import org.neo4j.index.impl.lucene.explicit.LuceneDataSource;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;

abstract class IndexReferenceFactory {
    private final File baseStorePath;
    private final IndexTypeCache typeCache;
    private final LuceneDataSource.LuceneFilesystemFacade filesystemFacade;

    IndexReferenceFactory(LuceneDataSource.LuceneFilesystemFacade filesystemFacade, File baseStorePath, IndexTypeCache typeCache) {
        this.filesystemFacade = filesystemFacade;
        this.baseStorePath = baseStorePath;
        this.typeCache = typeCache;
    }

    abstract IndexReference createIndexReference(IndexIdentifier var1) throws IOException, ExplicitIndexNotFoundKernelException;

    abstract IndexReference refresh(IndexReference var1) throws ExplicitIndexNotFoundKernelException;

    Directory getIndexDirectory(IndexIdentifier identifier) throws IOException {
        return this.filesystemFacade.getDirectory(this.baseStorePath, identifier);
    }

    IndexSearcher newIndexSearcher(IndexIdentifier identifier, IndexReader reader) throws ExplicitIndexNotFoundKernelException {
        IndexSearcher searcher = new IndexSearcher(reader);
        IndexType type = this.getType(identifier);
        if (type.getSimilarity() != null) {
            searcher.setSimilarity(type.getSimilarity());
        }
        return searcher;
    }

    IndexType getType(IndexIdentifier identifier) throws ExplicitIndexNotFoundKernelException {
        return this.typeCache.getIndexType(identifier, false);
    }
}

