/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector.codec;

import java.io.IOException;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.lucene99.Lucene99HnswScalarQuantizedVectorsFormat;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexConfig;

public class LuceneKnnScalarQuantizedVectorFormatV2
extends KnnVectorsFormat {
    private static final String LUCENE_SCALAR_QUANTIZED_VECTOR_FORMAT_V2_NAME = "LuceneKnnScalarQuantizedVectorFormatV2";
    private final KnnVectorsFormat vectorsFormat;
    private final int maxDimensions;

    public LuceneKnnScalarQuantizedVectorFormatV2() {
        this(Integer.MAX_VALUE, VectorIndexConfig.HnswConfig.DUMMY);
    }

    public LuceneKnnScalarQuantizedVectorFormatV2(int maxDimensions, VectorIndexConfig.HnswConfig hnswConfig) {
        super(LUCENE_SCALAR_QUANTIZED_VECTOR_FORMAT_V2_NAME);
        this.maxDimensions = maxDimensions;
        this.vectorsFormat = new Lucene99HnswScalarQuantizedVectorsFormat(hnswConfig.M(), hnswConfig.efConstruction());
    }

    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return this.vectorsFormat.fieldsWriter(state);
    }

    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return this.vectorsFormat.fieldsReader(state);
    }

    public int getMaxDimensions(String fieldName) {
        return this.maxDimensions;
    }
}

