/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.output;

import com.codahale.metrics.MetricRegistry;
import java.time.Duration;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.metrics.MetricsSettings;
import org.neo4j.metrics.output.CompositeEventReporter;
import org.neo4j.metrics.output.CsvOutput;
import org.neo4j.metrics.output.GraphiteOutput;
import org.neo4j.metrics.output.PrometheusOutput;
import org.neo4j.scheduler.JobScheduler;

public class EventReporterBuilder {
    private final Config config;
    private final MetricRegistry registry;
    private final Log logger;
    private final KernelContext kernelContext;
    private final LifeSupport life;
    private FileSystemAbstraction fileSystem;
    private JobScheduler scheduler;

    public EventReporterBuilder(Config config, MetricRegistry registry, Log logger, KernelContext kernelContext, LifeSupport life, FileSystemAbstraction fileSystem, JobScheduler scheduler) {
        this.config = config;
        this.registry = registry;
        this.logger = logger;
        this.kernelContext = kernelContext;
        this.life = life;
        this.fileSystem = fileSystem;
        this.scheduler = scheduler;
    }

    public CompositeEventReporter build() {
        HostnamePort server;
        CompositeEventReporter reporter = new CompositeEventReporter();
        String prefix = this.createMetricsPrefix(this.config);
        if (((Boolean)this.config.get(MetricsSettings.csvEnabled)).booleanValue()) {
            CsvOutput csvOutput = new CsvOutput(this.config, this.registry, this.logger, this.kernelContext, this.fileSystem, this.scheduler);
            reporter.add(csvOutput);
            this.life.add((Lifecycle)csvOutput);
        }
        if (((Boolean)this.config.get(MetricsSettings.graphiteEnabled)).booleanValue()) {
            server = (HostnamePort)this.config.get(MetricsSettings.graphiteServer);
            long period = ((Duration)this.config.get(MetricsSettings.graphiteInterval)).toMillis();
            GraphiteOutput graphiteOutput = new GraphiteOutput(server, period, this.registry, this.logger, prefix);
            reporter.add(graphiteOutput);
            this.life.add((Lifecycle)graphiteOutput);
        }
        if (((Boolean)this.config.get(MetricsSettings.prometheusEnabled)).booleanValue()) {
            server = (HostnamePort)this.config.get(MetricsSettings.prometheusEndpoint);
            PrometheusOutput prometheusOutput = new PrometheusOutput(server, this.registry, this.logger);
            reporter.add(prometheusOutput);
            this.life.add((Lifecycle)prometheusOutput);
        }
        return reporter;
    }

    private String createMetricsPrefix(Config config) {
        String prefix = (String)config.get(MetricsSettings.metricsPrefix);
        if (prefix.equals(MetricsSettings.metricsPrefix.getDefaultValue()) && config.isConfigured(ClusterSettings.server_id)) {
            prefix = prefix + "." + (String)config.get(ClusterSettings.cluster_name);
            prefix = prefix + "." + config.get(ClusterSettings.server_id);
        }
        return prefix;
    }
}

