/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.source.causalclustering;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.neo4j.causalclustering.catchup.tx.PullRequestMonitor;

class PullRequestMetric
implements PullRequestMonitor {
    private AtomicLong lastRequestedTxId = new AtomicLong(0L);
    private AtomicLong lastReceivedTxId = new AtomicLong(0L);
    private LongAdder events = new LongAdder();

    PullRequestMetric() {
    }

    public void txPullRequest(long txId) {
        this.events.increment();
        this.lastRequestedTxId.set(txId);
    }

    public void txPullResponse(long txId) {
        this.lastReceivedTxId.set(txId);
    }

    public long lastRequestedTxId() {
        return this.lastRequestedTxId.get();
    }

    public long numberOfRequests() {
        return this.events.longValue();
    }

    public long lastReceivedTxId() {
        return this.lastReceivedTxId.get();
    }
}

