/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.source.db;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.bolt.runtime.BoltConnectionMetricsMonitor;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.Monitors;

@Documented(value=".Bolt metrics")
public class BoltMetrics
extends LifecycleAdapter {
    private static final String NAME_PREFIX = "neo4j.bolt";
    @Documented(value="The total number of Bolt sessions started since this instance started. This includes both succeeded and failed sessions (deprecated, use connections_opened instead).")
    public static final String SESSIONS_STARTED = MetricRegistry.name((String)"neo4j.bolt", (String[])new String[]{"sessions_started"});
    @Documented(value="The total number of Bolt connections opened since this instance started. This includes both succeeded and failed connections.")
    public static final String CONNECTIONS_OPENED = MetricRegistry.name((String)"neo4j.bolt", (String[])new String[]{"connections_opened"});
    @Documented(value="The total number of Bolt connections closed since this instance started. This includes both properly and abnormally ended connections.")
    public static final String CONNECTIONS_CLOSED = MetricRegistry.name((String)"neo4j.bolt", (String[])new String[]{"connections_closed"});
    @Documented(value="The total number of Bolt connections currently being executed.")
    public static final String CONNECTIONS_RUNNING = MetricRegistry.name((String)"neo4j.bolt", (String[])new String[]{"connections_running"});
    @Documented(value="The total number of Bolt connections sitting idle.")
    public static final String CONNECTIONS_IDLE = MetricRegistry.name((String)"neo4j.bolt", (String[])new String[]{"connections_idle"});
    @Documented(value="The total number of messages received via Bolt since this instance started.")
    public static final String MESSAGES_RECIEVED = MetricRegistry.name((String)"neo4j.bolt", (String[])new String[]{"messages_received"});
    @Documented(value="The total number of messages that began processing since this instance started. This is different from messages received in that this counter tracks how many of the received messages havebeen taken on by a worker thread.")
    public static final String MESSAGES_STARTED = MetricRegistry.name((String)"neo4j.bolt", (String[])new String[]{"messages_started"});
    @Documented(value="The total number of messages that completed processing since this instance started. This includes successful, failed and ignored Bolt messages.")
    public static final String MESSAGES_DONE = MetricRegistry.name((String)"neo4j.bolt", (String[])new String[]{"messages_done"});
    @Documented(value="The total number of messages that failed processing since this instance started.")
    public static final String MESSAGES_FAILED = MetricRegistry.name((String)"neo4j.bolt", (String[])new String[]{"messages_failed"});
    @Documented(value="The accumulated time messages have spent waiting for a worker thread.")
    public static final String TOTAL_QUEUE_TIME = MetricRegistry.name((String)"neo4j.bolt", (String[])new String[]{"accumulated_queue_time"});
    @Documented(value="The accumulated time worker threads have spent processing messages.")
    public static final String TOTAL_PROCESSING_TIME = MetricRegistry.name((String)"neo4j.bolt", (String[])new String[]{"accumulated_processing_time"});
    private final MetricRegistry registry;
    private final Monitors monitors;
    private final BoltMetricsMonitor boltMonitor = new BoltMetricsMonitor();

    public BoltMetrics(MetricRegistry registry, Monitors monitors) {
        this.registry = registry;
        this.monitors = monitors;
    }

    public void start() {
        this.monitors.addMonitorListener((Object)this.boltMonitor, new String[0]);
        this.registry.register(SESSIONS_STARTED, (Metric)((Gauge)this.boltMonitor.connectionsOpened::get));
        this.registry.register(CONNECTIONS_OPENED, (Metric)((Gauge)this.boltMonitor.connectionsOpened::get));
        this.registry.register(CONNECTIONS_CLOSED, (Metric)((Gauge)this.boltMonitor.connectionsClosed::get));
        this.registry.register(CONNECTIONS_RUNNING, (Metric)((Gauge)this.boltMonitor.connectionsActive::get));
        this.registry.register(CONNECTIONS_IDLE, (Metric)((Gauge)this.boltMonitor.connectionsIdle::get));
        this.registry.register(MESSAGES_RECIEVED, (Metric)((Gauge)this.boltMonitor.messagesReceived::get));
        this.registry.register(MESSAGES_STARTED, (Metric)((Gauge)this.boltMonitor.messagesStarted::get));
        this.registry.register(MESSAGES_DONE, (Metric)((Gauge)this.boltMonitor.messagesDone::get));
        this.registry.register(MESSAGES_FAILED, (Metric)((Gauge)this.boltMonitor.messagesFailed::get));
        this.registry.register(TOTAL_QUEUE_TIME, (Metric)((Gauge)this.boltMonitor.queueTime::get));
        this.registry.register(TOTAL_PROCESSING_TIME, (Metric)((Gauge)this.boltMonitor.processingTime::get));
    }

    public void stop() {
        this.registry.remove(SESSIONS_STARTED);
        this.registry.remove(CONNECTIONS_OPENED);
        this.registry.remove(CONNECTIONS_CLOSED);
        this.registry.remove(CONNECTIONS_IDLE);
        this.registry.remove(CONNECTIONS_RUNNING);
        this.registry.remove(MESSAGES_RECIEVED);
        this.registry.remove(MESSAGES_STARTED);
        this.registry.remove(MESSAGES_DONE);
        this.registry.remove(MESSAGES_FAILED);
        this.registry.remove(TOTAL_QUEUE_TIME);
        this.registry.remove(TOTAL_PROCESSING_TIME);
        this.monitors.removeMonitorListener((Object)this.boltMonitor);
    }

    private class BoltMetricsMonitor
    implements BoltConnectionMetricsMonitor {
        final AtomicLong connectionsOpened = new AtomicLong();
        final AtomicLong connectionsClosed = new AtomicLong();
        final AtomicLong connectionsActive = new AtomicLong();
        final AtomicLong connectionsIdle = new AtomicLong();
        final AtomicLong messagesReceived = new AtomicLong();
        final AtomicLong messagesStarted = new AtomicLong();
        final AtomicLong messagesDone = new AtomicLong();
        final AtomicLong messagesFailed = new AtomicLong();
        final AtomicLong queueTime = new AtomicLong();
        final AtomicLong processingTime = new AtomicLong();

        private BoltMetricsMonitor() {
        }

        public void connectionOpened() {
            this.connectionsOpened.incrementAndGet();
            this.connectionsIdle.incrementAndGet();
        }

        public void connectionActivated() {
            this.connectionsActive.incrementAndGet();
            this.connectionsIdle.decrementAndGet();
        }

        public void connectionWaiting() {
            this.connectionsIdle.incrementAndGet();
            this.connectionsActive.decrementAndGet();
        }

        public void messageReceived() {
            this.messagesReceived.incrementAndGet();
        }

        public void messageProcessingStarted(long queueTime) {
            this.queueTime.addAndGet(queueTime);
            this.messagesStarted.incrementAndGet();
        }

        public void messageProcessingCompleted(long processingTime) {
            this.processingTime.addAndGet(processingTime);
            this.messagesDone.incrementAndGet();
        }

        public void messageProcessingFailed() {
            this.messagesFailed.incrementAndGet();
        }

        public void connectionClosed() {
            this.connectionsClosed.incrementAndGet();
            this.connectionsIdle.decrementAndGet();
        }
    }
}

