/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.monitoring;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.neo4j.logging.Log;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.DatabasePanicEventGenerator;
import org.neo4j.monitoring.Health;
import org.neo4j.util.VisibleForTesting;

public class CompositeDatabaseHealth
implements Health {
    private final CopyOnWriteArrayList<DatabaseHealth> healths;
    private volatile Throwable rootCauseOfPanic;

    public CompositeDatabaseHealth() {
        this.healths = new CopyOnWriteArrayList();
    }

    @VisibleForTesting
    CompositeDatabaseHealth(Collection<DatabaseHealth> healths) {
        this.healths = new CopyOnWriteArrayList<DatabaseHealth>(healths);
    }

    public DatabaseHealth createDatabaseHealth(DatabasePanicEventGenerator dbpe, Log log) {
        DatabaseHealth databaseHealth = new DatabaseHealth(dbpe, log);
        this.healths.add(databaseHealth);
        return databaseHealth;
    }

    void removeDatabaseHealth(DatabaseHealth health) {
        this.healths.remove(health);
    }

    @Override
    public <EXCEPTION extends Throwable> void assertHealthy(Class<EXCEPTION> panicDisguise) throws EXCEPTION {
        for (DatabaseHealth healthService : this.healths) {
            healthService.assertHealthy(panicDisguise);
        }
    }

    @Override
    public synchronized void panic(Throwable cause) {
        if (this.rootCauseOfPanic != null) {
            return;
        }
        Objects.requireNonNull(cause, "Must provide a non null cause for the panic");
        this.rootCauseOfPanic = cause;
        for (DatabaseHealth healthService : this.healths) {
            healthService.panic(cause);
        }
    }

    @Override
    public boolean isHealthy() {
        return this.healths.stream().allMatch(Health::isHealthy);
    }

    @Override
    public boolean healed() {
        return this.healths.stream().allMatch(Health::healed);
    }

    @Override
    public Throwable cause() {
        List exceptions = this.healths.stream().flatMap(h -> Optional.ofNullable(h.cause()).stream()).collect(Collectors.toList());
        if (exceptions.isEmpty()) {
            return null;
        }
        Throwable root = this.rootCauseOfPanic;
        Throwable identity = root != null ? root : new Exception("Some of the databases have panicked!");
        return exceptions.stream().reduce(identity, (acc, next) -> {
            acc.addSuppressed((Throwable)next);
            return acc;
        });
    }
}

