/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.monitoring;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.util.Preconditions;
import org.neo4j.util.VisibleForTesting;

public class VmPauseMonitor {
    private final long measurementDurationNs;
    private final long stallAlertThresholdNs;
    private final Monitor monitor;
    private final JobScheduler jobScheduler;
    private volatile boolean stopped;
    private JobHandle job;

    public VmPauseMonitor(Duration measureInterval, Duration stallAlertThreshold, Monitor monitor, JobScheduler jobScheduler) {
        this.measurementDurationNs = Preconditions.requirePositive((long)measureInterval.toNanos());
        this.stallAlertThresholdNs = Preconditions.requireNonNegative((long)stallAlertThreshold.toNanos());
        this.monitor = Objects.requireNonNull(monitor);
        this.jobScheduler = Objects.requireNonNull(jobScheduler);
    }

    public void start() {
        this.monitor.started();
        Preconditions.checkState((this.job == null ? 1 : 0) != 0, (String)"VM pause monitor is already started");
        this.stopped = false;
        this.job = Objects.requireNonNull(this.jobScheduler.schedule(Group.VM_PAUSE_MONITOR, this::run));
    }

    public void stop() {
        this.monitor.stopped();
        Preconditions.checkState((this.job != null ? 1 : 0) != 0, (String)"VM pause monitor is not started");
        this.stopped = true;
        this.job.cancel();
        this.job = null;
    }

    private void run() {
        try {
            this.monitor();
        }
        catch (InterruptedException ignore) {
            this.monitor.interrupted();
        }
        catch (RuntimeException e) {
            this.monitor.failed(e);
        }
    }

    @VisibleForTesting
    void monitor() throws InterruptedException {
        GcStats lastGcStats = VmPauseMonitor.getGcStats();
        long nextCheckPoint = System.nanoTime() + this.measurementDurationNs;
        while (!this.isStopped()) {
            TimeUnit.NANOSECONDS.sleep(this.measurementDurationNs);
            long now = System.nanoTime();
            long pauseNs = Math.max(0L, now - nextCheckPoint);
            nextCheckPoint = now + this.measurementDurationNs;
            GcStats gcStats = VmPauseMonitor.getGcStats();
            if (pauseNs >= this.stallAlertThresholdNs) {
                VmPauseInfo pauseInfo = new VmPauseInfo(TimeUnit.NANOSECONDS.toMillis(pauseNs), gcStats.time - lastGcStats.time, gcStats.count - lastGcStats.count);
                this.monitor.pauseDetected(pauseInfo);
            }
            lastGcStats = gcStats;
        }
    }

    @VisibleForTesting
    boolean isStopped() {
        return this.stopped;
    }

    private static GcStats getGcStats() {
        long time = 0L;
        long count = 0L;
        for (GarbageCollectorMXBean gcBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            time += gcBean.getCollectionTime();
            count += gcBean.getCollectionCount();
        }
        return new GcStats(time, count);
    }

    public static interface Monitor {
        public static final Monitor EMPTY = new Adapter();

        public void started();

        public void stopped();

        public void interrupted();

        public void failed(Exception var1);

        public void pauseDetected(VmPauseInfo var1);

        public static class Adapter
        implements Monitor {
            @Override
            public void started() {
            }

            @Override
            public void stopped() {
            }

            @Override
            public void interrupted() {
            }

            @Override
            public void failed(Exception e) {
            }

            @Override
            public void pauseDetected(VmPauseInfo info) {
            }
        }
    }

    private static class GcStats {
        private final long time;
        private final long count;

        private GcStats(long time, long count) {
            this.time = time;
            this.count = count;
        }
    }

    public static class VmPauseInfo {
        private final long pauseTime;
        private final long gcTime;
        private final long gcCount;

        public VmPauseInfo(long pauseTime, long gcTime, long gcCount) {
            this.pauseTime = pauseTime;
            this.gcTime = gcTime;
            this.gcCount = gcCount;
        }

        public long getPauseTime() {
            return this.pauseTime;
        }

        public String toString() {
            return String.format("{pauseTime=%d, gcTime=%d, gcCount=%d}", this.pauseTime, this.gcTime, this.gcCount);
        }
    }
}

