/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import org.neo4j.ogm.compiler.RelationshipBuilder;

public class TransientRelationship {
    private final Long src;
    private final Long tgt;
    private final Long ref;
    private final String rel;
    private final Class srcClass;
    private final Class tgtClass;

    public TransientRelationship(Long src, Long ref, String rel, Long tgt, Class srcClass, Class tgtClass) {
        this.src = src;
        this.tgt = tgt;
        this.ref = ref;
        this.rel = rel;
        this.srcClass = srcClass;
        this.tgtClass = tgtClass;
    }

    public boolean equalsIgnoreDirection(Long src, RelationshipBuilder builder, Long tgt) {
        Boolean singleton = builder.isSingleton();
        if (this.rel.equals(builder.type()) && singleton.booleanValue()) {
            if (this.src.equals(src) && this.tgt.equals(tgt)) {
                return true;
            }
            if (this.src.equals(tgt) && this.tgt.equals(src)) {
                return true;
            }
        }
        return false;
    }

    public Long getSrc() {
        return this.src;
    }

    public Long getTgt() {
        return this.tgt;
    }

    public Long getRef() {
        return this.ref;
    }

    public String getRel() {
        return this.rel;
    }

    public Class getSrcClass() {
        return this.srcClass;
    }

    public Class getTgtClass() {
        return this.tgtClass;
    }

    public String toString() {
        return String.format("(%s)-[%s:%s]->(%s)", this.src, this.ref, this.rel, this.tgt);
    }
}

