/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.entity.io;

import org.neo4j.ogm.entity.io.FieldWriter;
import org.neo4j.ogm.entity.io.PropertyReader;
import org.neo4j.ogm.entity.io.RelationalReader;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.ObjectAnnotations;

public class FieldReader
implements RelationalReader,
PropertyReader {
    private final ClassInfo classInfo;
    private final FieldInfo fieldInfo;

    public FieldReader(ClassInfo classInfo, FieldInfo fieldInfo) {
        this.classInfo = classInfo;
        this.fieldInfo = fieldInfo;
    }

    @Override
    public Object read(Object instance) {
        Object value = FieldWriter.read(this.classInfo.getField(this.fieldInfo), instance);
        if (this.fieldInfo.hasConverter()) {
            value = this.fieldInfo.converter().toGraphProperty(value);
        }
        return value;
    }

    @Override
    public String relationshipType() {
        return this.fieldInfo.relationship();
    }

    @Override
    public String propertyName() {
        return this.fieldInfo.property();
    }

    @Override
    public String relationshipDirection() {
        AnnotationInfo relationshipAnnotation;
        ObjectAnnotations annotations = this.fieldInfo.getAnnotations();
        if (annotations != null && (relationshipAnnotation = annotations.get("org.neo4j.ogm.annotation.Relationship")) != null) {
            return relationshipAnnotation.get("direction", "UNDIRECTED");
        }
        return "UNDIRECTED";
    }

    @Override
    public String typeParameterDescriptor() {
        return this.fieldInfo.getTypeDescriptor();
    }
}

