/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.metadata.ConstantPool;

public class AnnotationInfo {
    private String annotationName;
    private final Map<String, String> elements = new HashMap<String, String>();

    public AnnotationInfo(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        String annotationFieldDescriptor = constantPool.readString(dataInputStream.readUnsignedShort());
        String annotationClassName = annotationFieldDescriptor.charAt(0) == 'L' && annotationFieldDescriptor.charAt(annotationFieldDescriptor.length() - 1) == ';' ? annotationFieldDescriptor.substring(1, annotationFieldDescriptor.length() - 1).replace('/', '.') : annotationFieldDescriptor;
        this.setName(annotationClassName);
        int numElementValuePairs = dataInputStream.readUnsignedShort();
        for (int i = 0; i < numElementValuePairs; ++i) {
            String elementName = constantPool.readString(dataInputStream.readUnsignedShort());
            Object value = this.readAnnotationElementValue(dataInputStream, constantPool);
            if (elementName == null || value == null) continue;
            this.put(elementName, value.toString());
        }
    }

    public String getName() {
        return this.annotationName;
    }

    void setName(String annotationName) {
        this.annotationName = annotationName;
    }

    void put(String key, String value) {
        this.elements.put(key, value);
    }

    public String get(String key, String defaultValue) {
        if (this.elements.get(key) == null) {
            this.put(key, defaultValue);
        }
        return this.elements.get(key);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.annotationName);
        sb.append(": ");
        for (String key : this.elements.keySet()) {
            sb.append(key);
            sb.append(":'");
            sb.append(this.get(key, null));
            sb.append("'");
            sb.append(" ");
        }
        return sb.toString();
    }

    private Object readAnnotationElementValue(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int tag = dataInputStream.readUnsignedByte();
        switch (tag) {
            case 66: {
                return constantPool.readByte(dataInputStream.readUnsignedShort());
            }
            case 67: {
                return constantPool.readChar(dataInputStream.readUnsignedShort());
            }
            case 68: {
                return constantPool.readDouble(dataInputStream.readUnsignedShort());
            }
            case 70: {
                return constantPool.readFloat(dataInputStream.readUnsignedShort());
            }
            case 73: {
                return constantPool.readInteger(dataInputStream.readUnsignedShort());
            }
            case 74: {
                return constantPool.readLong(dataInputStream.readUnsignedShort());
            }
            case 83: {
                return constantPool.readShort(dataInputStream.readUnsignedShort());
            }
            case 115: {
                return constantPool.readString(dataInputStream.readUnsignedShort());
            }
            case 90: {
                return constantPool.readBoolean(dataInputStream.readUnsignedShort());
            }
            case 101: {
                dataInputStream.skipBytes(4);
                return null;
            }
            case 99: {
                return constantPool.readString(dataInputStream.readUnsignedShort());
            }
            case 64: {
                return new AnnotationInfo(dataInputStream, constantPool);
            }
            case 91: {
                int count = dataInputStream.readUnsignedShort();
                Object[] values = new Object[count];
                for (int l = 0; l < count; ++l) {
                    values[l] = this.readAnnotationElementValue(dataInputStream, constantPool);
                }
                return values;
            }
        }
        throw new ClassFormatError("Invalid annotation element type tag: 0x" + Integer.toHexString(tag));
    }
}

