/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.util.Collection;
import org.neo4j.ogm.annotations.Labels;
import org.neo4j.ogm.classloader.MetaDataClassLoader;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.ObjectAnnotations;
import org.neo4j.ogm.typeconversion.AttributeConverter;
import org.neo4j.ogm.utils.RelationshipUtils;

public class FieldInfo {
    private static final String primitives = "I,J,S,B,C,F,D,Z,[I,[J,[S,[B,[C,[F,[D,[Z";
    private final String name;
    private final String descriptor;
    private final String typeParameterDescriptor;
    private final ObjectAnnotations annotations;
    private AttributeConverter<?, ?> converter;

    public FieldInfo(String name, String descriptor, String typeParameterDescriptor, ObjectAnnotations annotations) {
        this.name = name;
        this.descriptor = descriptor;
        this.typeParameterDescriptor = typeParameterDescriptor;
        this.annotations = annotations;
        if (!this.annotations.isEmpty()) {
            this.setConverter(this.getAnnotations().getConverter());
        }
    }

    public String getName() {
        return this.name;
    }

    public String property() {
        if (this.isSimple()) {
            AnnotationInfo propertyAnnotation;
            if (this.annotations != null && (propertyAnnotation = this.annotations.get("org.neo4j.ogm.annotation.Property")) != null) {
                return propertyAnnotation.get("name", this.getName());
            }
            return this.getName();
        }
        return null;
    }

    public String relationship() {
        if (!this.isSimple()) {
            AnnotationInfo relationshipAnnotation;
            if (this.annotations != null && (relationshipAnnotation = this.annotations.get("org.neo4j.ogm.annotation.Relationship")) != null) {
                return relationshipAnnotation.get("type", RelationshipUtils.inferRelationshipType(this.getName()));
            }
            return RelationshipUtils.inferRelationshipType(this.getName());
        }
        return null;
    }

    public String relationshipTypeAnnotation() {
        AnnotationInfo relationshipAnnotation;
        if (!this.isSimple() && this.annotations != null && (relationshipAnnotation = this.annotations.get("org.neo4j.ogm.annotation.Relationship")) != null) {
            return relationshipAnnotation.get("type", null);
        }
        return null;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String getTypeParameterDescriptor() {
        return this.typeParameterDescriptor;
    }

    public ObjectAnnotations getAnnotations() {
        return this.annotations;
    }

    public boolean isSimple() {
        return primitives.contains(this.descriptor) || this.converter != null || this.descriptor.contains("java/lang/") && this.typeParameterDescriptor == null || this.typeParameterDescriptor != null && this.typeParameterDescriptor.contains("java/lang/");
    }

    public AttributeConverter converter() {
        return this.converter;
    }

    void setConverter(AttributeConverter<?, ?> converter) {
        if (this.converter == null && converter != null) {
            this.converter = converter;
        }
    }

    public boolean hasConverter() {
        return this.converter != null;
    }

    private AttributeConverter<?, ?> getAnnotatedTypeConverter() {
        return this.getAnnotations().getConverter();
    }

    public String relationshipDirection(String defaultDirection) {
        if (this.relationship() != null) {
            AnnotationInfo annotationInfo = this.getAnnotations().get("org.neo4j.ogm.annotation.Relationship");
            if (annotationInfo == null) {
                return defaultDirection;
            }
            return annotationInfo.get("direction", defaultDirection);
        }
        throw new RuntimeException("relationship direction call invalid");
    }

    public boolean isTypeOf(Class<?> type) {
        while (type != null) {
            String typeSignature = "L" + type.getName().replace(".", "/") + ";";
            if (this.descriptor != null && this.descriptor.equals(typeSignature)) {
                return true;
            }
            for (Class<?> iface : type.getInterfaces()) {
                typeSignature = "L" + iface.getName().replace(".", "/") + ";";
                if (this.descriptor == null || !this.descriptor.equals(typeSignature)) continue;
                return true;
            }
            type = type.getSuperclass();
        }
        return false;
    }

    public boolean isCollection() {
        String descriptorClass = this.getCollectionClassname();
        try {
            Class descriptorClazz = MetaDataClassLoader.loadClass((String)descriptorClass);
            if (Collection.class.isAssignableFrom(descriptorClazz)) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public boolean isParameterisedTypeOf(Class<?> type) {
        while (type != null) {
            String typeSignature = "L" + type.getName().replace(".", "/") + ";";
            if (this.typeParameterDescriptor != null && this.typeParameterDescriptor.equals(typeSignature)) {
                return true;
            }
            for (Class<?> iface : type.getInterfaces()) {
                typeSignature = "L" + iface.getName().replace(".", "/") + ";";
                if (this.typeParameterDescriptor == null || !this.typeParameterDescriptor.equals(typeSignature)) continue;
                return true;
            }
            type = type.getSuperclass();
        }
        return false;
    }

    public boolean isArrayOf(Class<?> type) {
        while (type != null) {
            String typeSignature = "[L" + type.getName().replace(".", "/") + ";";
            if (this.descriptor != null && this.descriptor.equals(typeSignature)) {
                return true;
            }
            for (Class<?> iface : type.getInterfaces()) {
                typeSignature = "[L" + iface.getName().replace(".", "/") + ";";
                if (this.descriptor == null || !this.descriptor.equals(typeSignature)) continue;
                return true;
            }
            type = type.getSuperclass();
        }
        return false;
    }

    public String getCollectionClassname() {
        String descriptorClass = this.descriptor.replace("/", ".");
        if (descriptorClass.startsWith("L")) {
            descriptorClass = descriptorClass.substring(1, descriptorClass.length() - 1);
        }
        return descriptorClass;
    }

    public boolean isScalar() {
        return this.typeParameterDescriptor == null && !this.descriptor.startsWith("[");
    }

    public boolean isLabelField() {
        return this.getAnnotations().get("org.neo4j.ogm.annotation.Labels") != null || this.getAnnotations().get(Labels.CLASS) != null;
    }

    public boolean isArray() {
        return this.descriptor.startsWith("[");
    }

    public boolean hasAnnotation(String annotationName) {
        return this.getAnnotations().get(annotationName) != null;
    }

    public String getTypeDescriptor() {
        if (this.isScalar() || this.isArray()) {
            return this.descriptor;
        }
        return this.typeParameterDescriptor;
    }
}

