/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.ConstantPool;
import org.neo4j.ogm.metadata.MethodInfo;
import org.neo4j.ogm.metadata.ObjectAnnotations;

public class MethodsInfo {
    private final Map<String, MethodInfo> methods = new HashMap<String, MethodInfo>();
    private final Map<String, MethodInfo> getters = new HashMap<String, MethodInfo>();
    private final Map<String, MethodInfo> setters = new HashMap<String, MethodInfo>();

    MethodsInfo() {
    }

    public MethodsInfo(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int methodCount = dataInputStream.readUnsignedShort();
        for (int i = 0; i < methodCount; ++i) {
            dataInputStream.skipBytes(2);
            String methodName = constantPool.readString(dataInputStream.readUnsignedShort());
            String descriptor = constantPool.readString(dataInputStream.readUnsignedShort());
            ObjectAnnotations objectAnnotations = new ObjectAnnotations();
            int attributesCount = dataInputStream.readUnsignedShort();
            String typeParameterDescriptor = null;
            for (int j = 0; j < attributesCount; ++j) {
                String attributeName = constantPool.readString(dataInputStream.readUnsignedShort());
                int attributeLength = dataInputStream.readInt();
                if ("RuntimeVisibleAnnotations".equals(attributeName)) {
                    int annotationCount = dataInputStream.readUnsignedShort();
                    for (int m = 0; m < annotationCount; ++m) {
                        AnnotationInfo info = new AnnotationInfo(dataInputStream, constantPool);
                        objectAnnotations.put(info.getName(), info);
                    }
                    continue;
                }
                if ("Signature".equals(attributeName)) {
                    String signature = constantPool.readString(dataInputStream.readUnsignedShort());
                    if (!signature.contains("<")) continue;
                    typeParameterDescriptor = signature.substring(signature.indexOf(60) + 1, signature.indexOf(62));
                    continue;
                }
                dataInputStream.skipBytes(attributeLength);
            }
            if (methodName.equals("<init>") || methodName.equals("<clinit>") || objectAnnotations.get("org.neo4j.ogm.annotation.Transient") != null) continue;
            this.addMethod(new MethodInfo(methodName, descriptor, typeParameterDescriptor, objectAnnotations));
        }
    }

    public Collection<MethodInfo> methods() {
        return this.methods.values();
    }

    public Collection<MethodInfo> getters() {
        return this.getters.values();
    }

    public Collection<MethodInfo> setters() {
        return this.setters.values();
    }

    public MethodInfo get(String methodName) {
        return this.methods.get(methodName);
    }

    public void append(MethodsInfo methodsInfo) {
        for (MethodInfo methodInfo : methodsInfo.methods()) {
            if (this.methods.containsKey(methodInfo.getName())) continue;
            this.addMethod(methodInfo);
        }
    }

    void removeGettersAndSetters(MethodInfo methodInfo) {
        this.getters.remove(methodInfo.getName());
        this.setters.remove(methodInfo.getName());
    }

    private void addMethod(MethodInfo methodInfo) {
        String methodName = methodInfo.getName();
        String descriptor = methodInfo.getDescriptor();
        this.methods.put(methodName, methodInfo);
        if (methodName.startsWith("get") && descriptor.startsWith("()")) {
            this.getters.put(methodName, methodInfo);
        } else if (methodName.startsWith("set") && descriptor.endsWith(")V")) {
            this.setters.put(methodName, methodInfo);
        }
    }
}

