/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.neo4j.ogm.cypher.query.DefaultRowModelRequest;
import org.neo4j.ogm.entity.io.FieldWriter;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.request.RowModelRequest;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.session.Capability;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.event.Event;
import org.neo4j.ogm.session.event.PersistenceEvent;
import org.neo4j.ogm.session.request.strategy.DeleteNodeStatements;
import org.neo4j.ogm.session.request.strategy.DeleteRelationshipStatements;
import org.neo4j.ogm.session.request.strategy.DeleteStatements;

public class DeleteDelegate
implements Capability.Delete {
    private final Neo4jSession session;

    public DeleteDelegate(Neo4jSession neo4jSession) {
        this.session = neo4jSession;
    }

    private DeleteStatements getDeleteStatementsBasedOnType(Class type) {
        if (this.session.metaData().isRelationshipEntity(type.getName())) {
            return new DeleteRelationshipStatements();
        }
        return new DeleteNodeStatements();
    }

    private <T> void deleteAll(T object) {
        List list = object.getClass().isArray() ? Collections.singletonList(object) : (List)object;
        if (!list.isEmpty()) {
            HashSet<Object> allNeighbours = new HashSet<Object>();
            for (Object element : list) {
                allNeighbours.addAll(this.session.context().neighbours(element));
            }
            this.deleteOneOrMoreObjects(allNeighbours, list);
        }
    }

    @Override
    public <T> void delete(T object) {
        if (object.getClass().isArray() || Iterable.class.isAssignableFrom(object.getClass())) {
            this.deleteAll(object);
        } else {
            this.deleteOneOrMoreObjects(this.session.context().neighbours(object), Collections.singletonList(object));
        }
    }

    private void deleteOneOrMoreObjects(Set<Object> neighbours, List<?> objects) {
        HashSet<Object> notified = new HashSet<Object>();
        if (this.session.eventsEnabled()) {
            for (Object affectedObject : neighbours) {
                if (notified.contains(affectedObject)) continue;
                this.session.notifyListeners(new PersistenceEvent(affectedObject, Event.TYPE.PRE_SAVE));
                notified.add(affectedObject);
            }
        }
        for (Object object : objects) {
            ClassInfo classInfo = this.session.metaData().classInfo(object);
            if (classInfo != null) {
                Field identityField = classInfo.getField(classInfo.identityField());
                Long identity = (Long)FieldWriter.read(identityField, object);
                if (identity == null) continue;
                Statement request = this.getDeleteStatementsBasedOnType(object.getClass()).delete(identity);
                if (this.session.eventsEnabled() && !notified.contains(object)) {
                    this.session.notifyListeners(new PersistenceEvent(object, Event.TYPE.PRE_DELETE));
                    notified.add(object);
                }
                DefaultRowModelRequest query = new DefaultRowModelRequest(request.getStatement(), request.getParameters());
                Response response = this.session.requestHandler().execute((RowModelRequest)query);
                Throwable throwable = null;
                try {
                    if (this.session.metaData().isRelationshipEntity(classInfo.name())) {
                        this.session.detachRelationshipEntity(identity);
                    } else {
                        this.session.detachNodeEntity(identity);
                    }
                    if (!this.session.eventsEnabled() || !notified.contains(object)) continue;
                    this.session.notifyListeners(new PersistenceEvent(object, Event.TYPE.POST_DELETE));
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (response == null) continue;
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    response.close();
                    continue;
                }
            }
            this.session.warn(object.getClass().getName() + " is not an instance of a persistable class");
        }
        if (this.session.eventsEnabled()) {
            for (Object affectedObject : neighbours) {
                if (!notified.contains(affectedObject)) continue;
                this.session.notifyListeners(new PersistenceEvent(affectedObject, Event.TYPE.POST_SAVE));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> void deleteAll(Class<T> type) {
        ClassInfo classInfo = this.session.metaData().classInfo(type.getName());
        if (classInfo != null) {
            Statement request = this.getDeleteStatementsBasedOnType(type).deleteByType(this.session.entityType(classInfo.name()));
            DefaultRowModelRequest query = new DefaultRowModelRequest(request.getStatement(), request.getParameters());
            this.session.notifyListeners(new PersistenceEvent(type, Event.TYPE.PRE_DELETE));
            try (Response response = this.session.requestHandler().execute((RowModelRequest)query);){
                this.session.context().removeType(type);
                if (!this.session.eventsEnabled()) return;
                this.session.notifyListeners(new PersistenceEvent(type, Event.TYPE.POST_DELETE));
                return;
            }
        } else {
            this.session.warn(type.getName() + " is not a persistable class");
        }
    }

    @Override
    public void purgeDatabase() {
        Statement stmt = new DeleteNodeStatements().purge();
        DefaultRowModelRequest query = new DefaultRowModelRequest(stmt.getStatement(), stmt.getParameters());
        this.session.requestHandler().execute((RowModelRequest)query).close();
        this.session.context().clear();
    }

    @Override
    public void clear() {
        this.session.context().clear();
    }
}

