/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import org.neo4j.ogm.context.GraphEntityMapper;
import org.neo4j.ogm.cypher.query.AbstractRequest;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.request.GraphModelRequest;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.session.Capability;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.request.strategy.QueryStatements;

public class LoadOneDelegate
implements Capability.LoadOne {
    private Neo4jSession session;

    public LoadOneDelegate(Neo4jSession session) {
        this.session = session;
    }

    @Override
    public <T> T load(Class<T> type, Long id) {
        return this.load(type, id, 1);
    }

    @Override
    public <T> T load(Class<T> type, Long id, int depth) {
        QueryStatements queryStatements = this.session.queryStatementsFor(type);
        AbstractRequest qry = queryStatements.findOne(id, depth);
        try (Response response = this.session.requestHandler().execute((GraphModelRequest)qry);){
            new GraphEntityMapper(this.session.metaData(), this.session.context()).map(type, (Response<GraphModel>)response);
            T t = this.lookup(type, id);
            return t;
        }
    }

    private <T> T lookup(Class<T> type, Long id) {
        ClassInfo typeInfo = this.session.metaData().classInfo(type.getName());
        Object ref = typeInfo.annotationsInfo().get("org.neo4j.ogm.annotation.RelationshipEntity") == null ? this.session.context().getNodeEntity(id) : this.session.context().getRelationshipEntity(id);
        try {
            return type.cast(ref);
        }
        catch (ClassCastException cce) {
            return null;
        }
    }
}

