/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.transaction;

import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.exception.TransactionManagerException;
import org.neo4j.ogm.service.Components;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.transaction.AbstractTransaction;
import org.neo4j.ogm.transaction.Transaction;
import org.neo4j.ogm.transaction.TransactionManager;

public class DefaultTransactionManager
implements TransactionManager {
    private final Driver driver;
    private final Session session;
    private static final ThreadLocal<Transaction> TRANSACTION_THREAD_LOCAL = new ThreadLocal();

    public DefaultTransactionManager(Session session) {
        this(session, Components.driver());
    }

    public DefaultTransactionManager(Session session, Driver driver) {
        this.driver = driver;
        this.driver.setTransactionManager((TransactionManager)this);
        this.session = session;
        TRANSACTION_THREAD_LOCAL.remove();
    }

    public Transaction openTransaction() {
        AbstractTransaction tx = (AbstractTransaction)TRANSACTION_THREAD_LOCAL.get();
        if (tx == null) {
            return this.openTransaction(Transaction.Type.READ_WRITE);
        }
        return this.openTransaction(tx.type());
    }

    public Transaction openTransaction(Transaction.Type type) {
        if (TRANSACTION_THREAD_LOCAL.get() == null) {
            TRANSACTION_THREAD_LOCAL.set(this.driver.newTransaction(type));
        } else {
            ((AbstractTransaction)TRANSACTION_THREAD_LOCAL.get()).extend(type);
        }
        return TRANSACTION_THREAD_LOCAL.get();
    }

    public void rollback(Transaction transaction) {
        if (transaction != this.getCurrentTransaction()) {
            throw new TransactionManagerException("Transaction is not current for this thread");
        }
        for (Object object : ((AbstractTransaction)transaction).registeredNew()) {
            ((Neo4jSession)this.session).context().reset(object);
        }
        TRANSACTION_THREAD_LOCAL.remove();
    }

    public void commit(Transaction tx) {
        if (tx != this.getCurrentTransaction()) {
            throw new TransactionManagerException("Transaction is not current for this thread");
        }
        TRANSACTION_THREAD_LOCAL.remove();
    }

    public Transaction getCurrentTransaction() {
        return TRANSACTION_THREAD_LOCAL.get();
    }

    public boolean canCommit() {
        if (this.getCurrentTransaction() == null) {
            return false;
        }
        AbstractTransaction tx = (AbstractTransaction)this.getCurrentTransaction();
        return tx.extensions() == 0L && (tx.status() == Transaction.Status.COMMIT_PENDING || tx.status() == Transaction.Status.OPEN || tx.status() == Transaction.Status.PENDING);
    }

    public boolean canRollback() {
        if (this.getCurrentTransaction() == null) {
            return false;
        }
        AbstractTransaction tx = (AbstractTransaction)this.getCurrentTransaction();
        return tx.extensions() == 0L && (tx.status() == Transaction.Status.ROLLBACK_PENDING || tx.status() == Transaction.Status.COMMIT_PENDING || tx.status() == Transaction.Status.OPEN || tx.status() == Transaction.Status.PENDING);
    }
}

