/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.neo4j.ogm.typeconversion.AttributeConverter;

public class DateArrayStringConverter
implements AttributeConverter<Date[], String[]> {
    private String format;

    public DateArrayStringConverter(String userDefinedFormat) {
        this.format = userDefinedFormat;
    }

    public String[] toGraphProperty(Date[] value) {
        if (value == null) {
            return null;
        }
        String[] values = new String[value.length];
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.format);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        int i = 0;
        for (Date date : value) {
            values[i++] = simpleDateFormat.format(date);
        }
        return values;
    }

    public Date[] toEntityAttribute(String[] dateValues) {
        if (dateValues == null) {
            return null;
        }
        Date[] dates = new Date[dateValues.length];
        int i = 0;
        try {
            for (String date : dateValues) {
                dates[i++] = new SimpleDateFormat(this.format).parse(date);
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return dates;
    }
}

