/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.ogm.typeconversion.AttributeConverter;

public class InstantStringConverter
implements AttributeConverter<Instant, String> {
    private final DateTimeFormatter formatter;
    private final boolean lenient;

    public InstantStringConverter() {
        this.formatter = DateTimeFormatter.ISO_INSTANT;
        this.lenient = false;
    }

    @Deprecated
    public InstantStringConverter(String userDefinedFormat, boolean lenient) {
        this(userDefinedFormat, "UTC", lenient);
    }

    public InstantStringConverter(String userDefinedFormat, String zoneId, boolean lenient) {
        this.formatter = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX".equals(userDefinedFormat) ? DateTimeFormatter.ISO_INSTANT : DateTimeFormatter.ofPattern(userDefinedFormat).withZone(ZoneId.of(zoneId));
        this.lenient = lenient;
    }

    @Override
    public String toGraphProperty(Instant value) {
        if (value == null) {
            return null;
        }
        return this.formatter.format(value);
    }

    @Override
    public Instant toEntityAttribute(String value) {
        if (value == null || this.lenient && StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return this.formatter.parse((CharSequence)value, Instant::from);
    }
}

