/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.function;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.function.DistanceFromNativePoint;
import org.neo4j.ogm.cypher.function.FilterFunction;

public class NativeDistanceComparison
implements FilterFunction<DistanceFromNativePoint> {
    private static final String DISTANCE_VALUE_PARAMETER = "distanceValue";
    private static final String OGM_POINT_PARAMETER = "ogmPoint";
    private final DistanceFromNativePoint distanceFromNativePoint;
    private Filter filter;

    private NativeDistanceComparison(DistanceFromNativePoint distanceFromNativePoint) {
        this.distanceFromNativePoint = distanceFromNativePoint;
    }

    public static NativeDistanceComparison distanceComparisonFor(DistanceFromNativePoint distanceFromNativePoint) {
        return new NativeDistanceComparison(distanceFromNativePoint);
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public DistanceFromNativePoint getValue() {
        return this.distanceFromNativePoint;
    }

    @Override
    public String expression(String nodeIdentifier) {
        String pointPropertyOfEntity = nodeIdentifier + "." + this.getFilter().getPropertyName();
        String comparisonOperator = this.getFilter().getComparisonOperator().getValue();
        return String.format("distance({%s},%s) %s {%s} ", OGM_POINT_PARAMETER, pointPropertyOfEntity, comparisonOperator, DISTANCE_VALUE_PARAMETER);
    }

    @Override
    public Map<String, Object> parameters() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(OGM_POINT_PARAMETER, this.distanceFromNativePoint.getPoint());
        map.put(DISTANCE_VALUE_PARAMETER, this.distanceFromNativePoint.getDistance());
        return map;
    }
}

