/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public final class GenericUtils {
    public static boolean isGenericField(Field field) {
        return field.getGenericType() instanceof TypeVariable;
    }

    public static boolean isParameterizedField(Field field) {
        return field.getGenericType() instanceof ParameterizedType;
    }

    public static Class findFieldType(Field field, Class concreteClass) {
        Class<?>[] arguments = GenericUtils.resolveRawArguments(field.getGenericType(), concreteClass);
        if (arguments == null || arguments.length == 0 || arguments[0] == Unknown.class) {
            return GenericUtils.isParameterizedField(field) ? Object.class : field.getType();
        }
        return arguments[0];
    }

    private static Class<?>[] resolveRawArguments(Type genericType, Class<?> subType) {
        Class[] result;
        block5: {
            Class functionalInterface;
            block6: {
                block4: {
                    result = null;
                    functionalInterface = null;
                    if (subType.isSynthetic()) {
                        Class fi;
                        Class clazz = genericType instanceof ParameterizedType && ((ParameterizedType)genericType).getRawType() instanceof Class ? (Class)((ParameterizedType)genericType).getRawType() : (fi = genericType instanceof Class ? (Class)genericType : null);
                        if (fi != null && fi.isInterface()) {
                            functionalInterface = fi;
                        }
                    }
                    if (!(genericType instanceof ParameterizedType)) break block4;
                    ParameterizedType paramType = (ParameterizedType)genericType;
                    Type[] arguments = paramType.getActualTypeArguments();
                    result = new Class[arguments.length];
                    for (int i = 0; i < arguments.length; ++i) {
                        result[i] = GenericUtils.resolveRawClass(arguments[i], subType, functionalInterface);
                    }
                    break block5;
                }
                if (!(genericType instanceof TypeVariable)) break block6;
                result = new Class[]{GenericUtils.resolveRawClass(genericType, subType, functionalInterface)};
                break block5;
            }
            if (!(genericType instanceof Class)) break block5;
            TypeVariable<Class<T>>[] typeParams = ((Class)genericType).getTypeParameters();
            result = new Class[typeParams.length];
            for (int i = 0; i < typeParams.length; ++i) {
                result[i] = GenericUtils.resolveRawClass(typeParams[i], subType, functionalInterface);
            }
        }
        return result;
    }

    private static Class<?> resolveRawClass(Type genericType, Class<?> subType, Class<?> functionalInterface) {
        if (genericType instanceof Class) {
            return (Class)genericType;
        }
        if (genericType instanceof ParameterizedType) {
            return GenericUtils.resolveRawClass(((ParameterizedType)genericType).getRawType(), subType, functionalInterface);
        }
        if (genericType instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)genericType;
            Class<?> component = GenericUtils.resolveRawClass(arrayType.getGenericComponentType(), subType, functionalInterface);
            return Array.newInstance(component, 0).getClass();
        }
        if (genericType instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)genericType;
            genericType = GenericUtils.getTypeVariableMap(subType, functionalInterface).get(variable);
            genericType = genericType == null ? GenericUtils.resolveBound(variable) : GenericUtils.resolveRawClass(genericType, subType, functionalInterface);
        }
        return genericType instanceof Class ? (Class)genericType : Unknown.class;
    }

    private static Map<TypeVariable<?>, Type> getTypeVariableMap(Class<?> targetType, Class<?> functionalInterface) {
        Class<?> type;
        HashMap map = new HashMap();
        GenericUtils.populateSuperTypeArgs(targetType.getGenericInterfaces(), map, functionalInterface != null);
        Type genericType = targetType.getGenericSuperclass();
        for (type = targetType.getSuperclass(); type != null && !Object.class.equals(type); type = type.getSuperclass()) {
            if (genericType instanceof ParameterizedType) {
                GenericUtils.populateTypeArgs((ParameterizedType)genericType, map, false);
            }
            GenericUtils.populateSuperTypeArgs(type.getGenericInterfaces(), map, false);
            genericType = type.getGenericSuperclass();
        }
        type = targetType;
        while (type.isMemberClass()) {
            genericType = type.getGenericSuperclass();
            if (genericType instanceof ParameterizedType) {
                GenericUtils.populateTypeArgs((ParameterizedType)genericType, map, functionalInterface != null);
            }
            type = type.getEnclosingClass();
        }
        return map;
    }

    private static void populateSuperTypeArgs(Type[] types, Map<TypeVariable<?>, Type> map, boolean depthFirst) {
        for (Type type : types) {
            if (type instanceof ParameterizedType) {
                Type rawType;
                ParameterizedType parameterizedType = (ParameterizedType)type;
                if (!depthFirst) {
                    GenericUtils.populateTypeArgs(parameterizedType, map, depthFirst);
                }
                if ((rawType = parameterizedType.getRawType()) instanceof Class) {
                    GenericUtils.populateSuperTypeArgs(((Class)rawType).getGenericInterfaces(), map, depthFirst);
                }
                if (!depthFirst) continue;
                GenericUtils.populateTypeArgs(parameterizedType, map, depthFirst);
                continue;
            }
            if (!(type instanceof Class)) continue;
            GenericUtils.populateSuperTypeArgs(((Class)type).getGenericInterfaces(), map, depthFirst);
        }
    }

    private static void populateTypeArgs(ParameterizedType type, Map<TypeVariable<?>, Type> map, boolean depthFirst) {
        if (type.getRawType() instanceof Class) {
            Type owner;
            TypeVariable<Class<T>>[] typeVariables = ((Class)type.getRawType()).getTypeParameters();
            Type[] typeArguments = type.getActualTypeArguments();
            if (type.getOwnerType() != null && (owner = type.getOwnerType()) instanceof ParameterizedType) {
                GenericUtils.populateTypeArgs((ParameterizedType)owner, map, depthFirst);
            }
            for (int i = 0; i < typeArguments.length; ++i) {
                Type existingType;
                TypeVariable variable = typeVariables[i];
                Type typeArgument = typeArguments[i];
                if (typeArgument instanceof Class) {
                    map.put(variable, typeArgument);
                    continue;
                }
                if (typeArgument instanceof GenericArrayType) {
                    map.put(variable, typeArgument);
                    continue;
                }
                if (typeArgument instanceof ParameterizedType) {
                    map.put(variable, typeArgument);
                    continue;
                }
                if (!(typeArgument instanceof TypeVariable)) continue;
                TypeVariable typeVariableArgument = (TypeVariable)typeArgument;
                if (depthFirst && (existingType = map.get(variable)) != null) {
                    map.put(typeVariableArgument, existingType);
                    continue;
                }
                Type resolvedType = map.get(typeVariableArgument);
                if (resolvedType == null) {
                    resolvedType = GenericUtils.resolveBound(typeVariableArgument);
                }
                map.put(variable, resolvedType);
            }
        }
    }

    private static Type resolveBound(TypeVariable<?> typeVariable) {
        Type[] bounds = typeVariable.getBounds();
        if (bounds.length == 0) {
            return Unknown.class;
        }
        Type bound = bounds[0];
        if (bound instanceof TypeVariable) {
            bound = GenericUtils.resolveBound((TypeVariable)bound);
        }
        return bound == Object.class ? Unknown.class : bound;
    }

    private GenericUtils() {
    }

    private static final class Unknown {
        private Unknown() {
        }
    }
}

