/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.util.Arrays;
import org.neo4j.internal.kernel.api.LabelSet;

public class SortedLabels {
    private long[] labels;

    private SortedLabels(long[] labels) {
        this.labels = labels;
    }

    public static SortedLabels from(long[] labels) {
        Arrays.sort(labels);
        return new SortedLabels(labels);
    }

    static SortedLabels from(LabelSet labelSet) {
        return SortedLabels.from(labelSet.all());
    }

    private long[] all() {
        return this.labels;
    }

    public int hashCode() {
        return Arrays.hashCode(this.labels);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SortedLabels) {
            long[] input = ((SortedLabels)obj).all();
            return Arrays.equals(this.labels, input);
        }
        return false;
    }

    public int numberOfLabels() {
        return this.labels.length;
    }

    public Integer label(int offset) {
        return (int)this.labels[offset];
    }
}

