/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;

public final class QueryId {
    public static final String PREFIX = "query-";
    private static final String EXPECTED_FORMAT_MSG = "(expected format: query-<id>)";

    private QueryId() {
    }

    public static long parse(String queryIdText) throws InvalidArgumentsException {
        try {
            if (!queryIdText.startsWith(PREFIX)) {
                throw new InvalidArgumentsException("Expected prefix query-");
            }
            String qid = queryIdText.substring(PREFIX.length());
            long internalId = Long.parseLong(qid);
            if (internalId <= 0L) {
                throw new InvalidArgumentsException("Negative ids are not supported (expected format: query-<id>)");
            }
            return internalId;
        }
        catch (Exception e) {
            throw new InvalidArgumentsException("Could not parse id " + queryIdText + " (expected format: query-<id>)", (Throwable)e);
        }
    }
}

