/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.util.function.ToIntFunction;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.security.User;

public class BasicLoginContext
implements LoginContext {
    private final BasicAuthSubject authSubject;
    private AccessMode accessMode;

    public BasicLoginContext(User user, AuthenticationResult authenticationResult) {
        this.authSubject = new BasicAuthSubject(user, authenticationResult);
        switch (authenticationResult) {
            case SUCCESS: {
                this.accessMode = AccessMode.Static.FULL;
                break;
            }
            case PASSWORD_CHANGE_REQUIRED: {
                this.accessMode = AccessMode.Static.CREDENTIALS_EXPIRED;
                break;
            }
            default: {
                this.accessMode = AccessMode.Static.NONE;
            }
        }
    }

    public AuthSubject subject() {
        return this.authSubject;
    }

    public SecurityContext authorize(ToIntFunction<String> propertyIdLookup, String dbName) {
        return new SecurityContext((AuthSubject)this.authSubject, this.accessMode);
    }

    private class BasicAuthSubject
    implements AuthSubject {
        private User user;
        private AuthenticationResult authenticationResult;

        BasicAuthSubject(User user, AuthenticationResult authenticationResult) {
            this.user = user;
            this.authenticationResult = authenticationResult;
        }

        public void logout() {
            this.user = null;
            this.authenticationResult = AuthenticationResult.FAILURE;
        }

        public AuthenticationResult getAuthenticationResult() {
            return this.authenticationResult;
        }

        public void setPasswordChangeNoLongerRequired() {
            if (this.authenticationResult == AuthenticationResult.PASSWORD_CHANGE_REQUIRED) {
                this.authenticationResult = AuthenticationResult.SUCCESS;
                BasicLoginContext.this.accessMode = (AccessMode)AccessMode.Static.FULL;
            }
        }

        public String username() {
            return this.user.name();
        }

        public boolean hasUsername(String username) {
            return this.username().equals(username);
        }
    }
}

