/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.nio.file.Path;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.Log;

public interface FileRepository {
    public static Path getMigratedFile(Path path) {
        return path.resolveSibling(path.getFileName() + ".migrated");
    }

    public static void assertNotMigrated(Path path, FileSystemAbstraction fileSystem, Log log) {
        Path migratedFile = FileRepository.getMigratedFile(path);
        if (fileSystem.fileExists(migratedFile)) {
            String message = "The repository file '" + path.toAbsolutePath() + "' has been marked as migrated. If you are sure that you want use this repository you need to manually rename the file '" + migratedFile.toAbsolutePath() + "' to '" + path.getFileName() + "'";
            log.error(message);
            throw new IllegalStateException(message);
        }
    }
}

