/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.counts.CountUpdater;
import org.neo4j.internal.counts.CountsKey;
import org.neo4j.internal.counts.CountsValue;
import org.neo4j.io.IOUtils;
import org.neo4j.logging.LogProvider;

class TreeWriter
implements CountUpdater.CountWriter {
    private static final ValueMerger<CountsKey, CountsValue> REPLACING_MERGER = (existingKey, newKey, existingValue, newValue) -> ValueMerger.MergeResult.REPLACED;
    private final Writer<CountsKey, CountsValue> treeWriter;
    private final CountsValue value = new CountsValue();
    private final LogProvider userLogProvider;

    TreeWriter(Writer<CountsKey, CountsValue> treeWriter, LogProvider userLogProvider) {
        this.treeWriter = treeWriter;
        this.userLogProvider = userLogProvider;
    }

    @Override
    public void write(CountsKey key, long delta) {
        this.merge(this.treeWriter, key, this.value.initialize(delta));
    }

    @Override
    public void close() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new Writer[]{this.treeWriter});
    }

    private void merge(Writer<CountsKey, CountsValue> writer, CountsKey key, CountsValue value) {
        if (value.count > 0L) {
            writer.merge((Object)key, (Object)value, REPLACING_MERGER);
        } else if (value.count == 0L) {
            writer.remove((Object)key);
        } else {
            this.userLogProvider.getLog(this.getClass()).error("Key '" + String.valueOf(key) + "' has a negative count.\nThis is a serious error which is typically caused by a store corruption\nEven thought the database will continue operating, it will do so with reduced functionality\nThe best cause of action is running the consistency checker, fixing the corruption and rebuilding the count store\nCounts for the problematic key will not be available until the count store is rebuilt.\n");
            writer.merge((Object)key, (Object)new CountsValue().initialize(-1L), REPLACING_MERGER);
        }
    }
}

