/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.LongSupplier;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.schema.AnyTokenSchemaDescriptor;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.storageengine.api.SchemaRule44;
import org.neo4j.token.TokenHolders;

public class SchemaStore44MigrationUtil {
    public static final AnyTokenSchemaDescriptor FORMER_LABEL_SCAN_STORE_SCHEMA = SchemaDescriptors.ANY_TOKEN_NODE_SCHEMA_DESCRIPTOR;
    public static final String FORMER_LABEL_SCAN_STORE_GENERATED_NAME = "__org_neo4j_schema_index_label_scan_store_converted_to_token_index";

    static SchemaInfo44 extractRuleInfo(boolean shouldCreateNewSchemaStore, List<SchemaRule44> all) {
        SchemaRule44.Index nli;
        ArrayList<SchemaRule44> toDelete = new ArrayList<SchemaRule44>();
        ArrayList<SchemaRule> toCreate = new ArrayList<SchemaRule>();
        HashMap<SchemaDescriptor, List> indexesBySchema = new HashMap<SchemaDescriptor, List>();
        HashMap<String, SchemaRule44.Index> uniqueIndexesByName = new HashMap<String, SchemaRule44.Index>();
        HashMap<SchemaDescriptor, EnumMap> constraintBySchemaAndType = new HashMap<SchemaDescriptor, EnumMap>();
        for (SchemaRule44 schemaRule : all) {
            if (schemaRule instanceof SchemaRule44.Index) {
                SchemaRule44.Index index = (SchemaRule44.Index)schemaRule;
                if (!index.unique()) {
                    indexesBySchema.computeIfAbsent(index.schema(), k -> new ArrayList()).add(index);
                } else {
                    uniqueIndexesByName.put(index.name(), index);
                }
                if (shouldCreateNewSchemaStore && index.indexType() != SchemaRule44.IndexType.BTREE) {
                    toCreate.add(schemaRule.convertTo50rule());
                }
            }
            if (!(schemaRule instanceof SchemaRule44.Constraint)) continue;
            SchemaRule44.Constraint constraint = (SchemaRule44.Constraint)schemaRule;
            boolean indexBacked = constraint.constraintRuleType().isIndexBacked();
            if (indexBacked) {
                EnumMap constraintsByType = constraintBySchemaAndType.computeIfAbsent(constraint.schema(), k -> new EnumMap(SchemaRule44.ConstraintRuleType.class));
                constraintsByType.computeIfAbsent(constraint.constraintRuleType(), k -> new ArrayList()).add(constraint);
            }
            if (!shouldCreateNewSchemaStore || indexBacked && constraint.indexType() != SchemaRule44.IndexType.RANGE) continue;
            toCreate.add(schemaRule.convertTo50rule());
        }
        List nlis = (List)indexesBySchema.get(FORMER_LABEL_SCAN_STORE_SCHEMA);
        if (!shouldCreateNewSchemaStore && nlis != null && !nlis.isEmpty() && FORMER_LABEL_SCAN_STORE_GENERATED_NAME.equals((nli = (SchemaRule44.Index)nlis.get(0)).name())) {
            toCreate.add(nli.convertTo50rule());
        }
        ArrayList<SchemaRule44.Index> nonReplacedIndexes = new ArrayList<SchemaRule44.Index>();
        for (SchemaDescriptor schema : indexesBySchema.keySet()) {
            List indexes = (List)indexesBySchema.get(schema);
            for (SchemaRule44.Index index : indexes) {
                if (index.indexType() != SchemaRule44.IndexType.BTREE) continue;
                if (indexes.size() == 1) {
                    nonReplacedIndexes.add(index);
                    continue;
                }
                toDelete.add((SchemaRule44)index);
            }
        }
        ArrayList<Pair<SchemaRule44.Constraint, SchemaRule44.Index>> nonReplacedConstraints = new ArrayList<Pair<SchemaRule44.Constraint, SchemaRule44.Index>>();
        constraintBySchemaAndType.values().stream().flatMap(enumMap -> enumMap.values().stream()).forEach(constraintsGroupedBySchemaAndType -> {
            for (SchemaRule44.Constraint constraint : constraintsGroupedBySchemaAndType) {
                SchemaRule44.Index backingIndex = (SchemaRule44.Index)uniqueIndexesByName.remove(constraint.name());
                if (backingIndex.indexType() != SchemaRule44.IndexType.BTREE) continue;
                if (constraintsGroupedBySchemaAndType.size() == 1) {
                    nonReplacedConstraints.add(Pair.of((Object)constraint, (Object)backingIndex));
                    continue;
                }
                toDelete.add((SchemaRule44)constraint);
                toDelete.add((SchemaRule44)backingIndex);
            }
        });
        for (SchemaRule44.Index uniqueIndex : uniqueIndexesByName.values()) {
            if (uniqueIndex.indexType() != SchemaRule44.IndexType.BTREE) continue;
            nonReplacedIndexes.add(uniqueIndex);
        }
        return new SchemaInfo44(toDelete, toCreate, nonReplacedIndexes, nonReplacedConstraints);
    }

    static void assertCanMigrate(boolean forceBtreeIndexesToRange, List<SchemaRule44.Index> nonReplacedIndexes, List<Pair<SchemaRule44.Constraint, SchemaRule44.Index>> nonReplacedConstraints, TokenHolders srcTokenHolders) {
        if (!(forceBtreeIndexesToRange || nonReplacedIndexes.isEmpty() && nonReplacedConstraints.isEmpty())) {
            StringJoiner nonReplacedIndexString = new StringJoiner(", ", "[", "]");
            StringJoiner nonReplacedConstraintsString = new StringJoiner(", ", "[", "]");
            nonReplacedIndexes.forEach(index -> nonReplacedIndexString.add(index.userDescription((TokenNameLookup)srcTokenHolders)));
            nonReplacedConstraints.forEach(pair -> nonReplacedConstraintsString.add(((SchemaRule44.Constraint)pair.first()).userDescription((TokenNameLookup)srcTokenHolders)));
            throw new IllegalStateException("Migration will remove all BTREE indexes and constraints backed by BTREE indexes. To guard against unintentionally removing indexes or constraints, it is recommended for all BTREE indexes or constraints backed by BTREE indexes to have a valid replacement. Indexes can be replaced by RANGE, TEXT or POINT index and constraints can be replaced by constraints backed by RANGE index. Please drop your indexes and constraints or create replacements and retry the migration. The indexes and constraints without replacement are: " + nonReplacedIndexString + " and " + nonReplacedConstraintsString + ". Alternatively, you can use the option --force-btree-indexes-to-range to force all BTREE indexes or constraints backed by BTREE indexes to be replaced by RANGE equivalents. Be aware that RANGE indexes are not always the optimal replacement of BTREEs and performance may be affected while the new indexes are populated. See the Neo4j v5 migration guide online for more information.");
        }
    }

    static ConstraintDescriptor asRangeBackedConstraint(SchemaRule44.Constraint constraint, IndexDescriptor rangeIndex, LongSupplier idSupplier, TokenHolders dstTokensHolders) {
        UniquenessConstraintDescriptor newConstraint;
        if (constraint.constraintRuleType() == SchemaRule44.ConstraintRuleType.UNIQUE) {
            newConstraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)constraint.schema(), (IndexType)rangeIndex.getIndexType());
        } else if (constraint.constraintRuleType() == SchemaRule44.ConstraintRuleType.UNIQUE_EXISTS) {
            newConstraint = ConstraintDescriptorFactory.keyForSchema((SchemaDescriptor)constraint.schema(), (IndexType)rangeIndex.getIndexType());
        } else {
            throw new IllegalStateException("We should never see non-index-backed constraint here, but got: " + constraint.userDescription((TokenNameLookup)dstTokensHolders));
        }
        return newConstraint.withOwnedIndexId(rangeIndex.getId()).withName(constraint.name()).withId(idSupplier.getAsLong());
    }

    static IndexDescriptor asRangeIndex(SchemaRule44.Index btreeIndex, LongSupplier idSupplier) {
        IndexPrototype prototype = btreeIndex.unique() ? IndexPrototype.uniqueForSchema((SchemaDescriptor)btreeIndex.schema()) : IndexPrototype.forSchema((SchemaDescriptor)btreeIndex.schema());
        return prototype.withName(btreeIndex.name()).withIndexType(IndexType.RANGE).withIndexProvider(new IndexProviderDescriptor("range", "1.0")).materialise(idSupplier.getAsLong());
    }

    record SchemaInfo44(ArrayList<SchemaRule44> toDelete, ArrayList<SchemaRule> toCreate, ArrayList<SchemaRule44.Index> nonReplacedIndexes, ArrayList<Pair<SchemaRule44.Constraint, SchemaRule44.Index>> nonReplacedConstraints) {
    }
}

