/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.stats;

import org.neo4j.io.pagecache.PageCursor;

class IndexStatisticsKey
implements Comparable<IndexStatisticsKey> {
    static final int SIZE = 64;
    static final byte TYPE_SAMPLE = 0;
    static final byte TYPE_USAGE = 1;
    private static final int NUM_TYPE_BITS = 8;
    private static final int NUM_INDEX_ID_BITS = 56;
    private static final int SHIFT_TYPE_BITS = 56;
    private static final long MASK_INDEX_ID = 0xFFFFFFFFFFFFFFL;
    private static final long MASK_TYPE = 255L;
    static final long MIN_INDEX_ID = 0L;
    static final long MAX_INDEX_ID = 0xFFFFFFFFFFFFFFL;
    long key;

    IndexStatisticsKey() {
    }

    IndexStatisticsKey(long indexId, byte type) {
        this.set(indexId, type);
    }

    long getIndexId() {
        return this.key & 0xFFFFFFFFFFFFFFL;
    }

    byte getType() {
        return (byte)(this.key >>> 56 & 0xFFL);
    }

    void set(long indexId, byte type) {
        this.key = IndexStatisticsKey.combine(indexId, type);
    }

    public int hashCode() {
        return Long.hashCode(this.key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexStatisticsKey that = (IndexStatisticsKey)o;
        return this.key == that.key;
    }

    public String toString() {
        return String.format("[type:%d, indexId:%d]", this.getType(), this.getIndexId());
    }

    @Override
    public int compareTo(IndexStatisticsKey other) {
        return Long.compare(this.key, other.key);
    }

    private static long combine(long indexId, byte type) {
        return indexId | ((long)type & 0xFFL) << 56;
    }

    void initializeAsLowest() {
        this.set(0L, (byte)0);
    }

    void initializeAsHighest() {
        this.set(0xFFFFFFFFFFFFFFL, (byte)1);
    }

    void write(PageCursor cursor) {
        cursor.putLong(this.key);
    }

    void read(PageCursor cursor) {
        this.key = cursor.getLong();
    }

    void copyFrom(IndexStatisticsKey source) {
        this.key = source.key;
    }
}

