/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ext.udc.impl;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.neo4j.ext.udc.impl.UdcInformationCollector;
import org.neo4j.helpers.HostnamePort;

class Pinger {
    private final HostnamePort address;
    private final UdcInformationCollector collector;
    private int pingCount;

    Pinger(HostnamePort address, UdcInformationCollector collector) {
        this.address = address;
        this.collector = collector;
    }

    void ping() throws IOException {
        ++this.pingCount;
        Map<String, String> usageDataMap = this.collector.getUdcParams();
        StringBuilder uri = new StringBuilder("http://" + this.address + "/?");
        for (Map.Entry<String, String> entry : usageDataMap.entrySet()) {
            uri.append(entry.getKey());
            uri.append("=");
            uri.append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.name()));
            uri.append("+");
        }
        uri.append("p=").append(this.pingCount);
        URL url = new URL(uri.toString());
        URLConnection con = url.openConnection();
        con.setDoInput(true);
        con.setDoOutput(false);
        con.setUseCaches(false);
        con.connect();
        con.getInputStream().close();
    }

    int getPingCount() {
        return this.pingCount;
    }
}

