/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.unsafe;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import sun.misc.Unsafe;

final class UnsafeAccessor {
    private UnsafeAccessor() {
    }

    static Unsafe getUnsafe() {
        try {
            PrivilegedExceptionAction<Unsafe> getUnsafe = () -> {
                try {
                    return Unsafe.getUnsafe();
                }
                catch (Exception e) {
                    Field[] fields;
                    Class<Unsafe> type = Unsafe.class;
                    for (Field field : fields = type.getDeclaredFields()) {
                        if (!Modifier.isStatic(field.getModifiers()) || !type.isAssignableFrom(field.getType())) continue;
                        field.setAccessible(true);
                        return (Unsafe)type.cast(field.get(null));
                    }
                    LinkageError error = new LinkageError("No static field of type sun.misc.Unsafe");
                    error.addSuppressed(e);
                    throw error;
                }
            };
            return AccessController.doPrivileged(getUnsafe);
        }
        catch (Exception e) {
            throw new LinkageError("Cannot access sun.misc.Unsafe", e);
        }
    }
}

