/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.List;
import java.util.Objects;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.ValueRepresentation;

final class ArrayHelpers {
    private ArrayHelpers() {
    }

    static boolean containsNull(AnyValue[] values) {
        for (AnyValue value : values) {
            if (value != null) continue;
            return true;
        }
        return false;
    }

    static boolean containsNull(List<AnyValue> values) {
        for (AnyValue value : values) {
            if (value != null) continue;
            return true;
        }
        return false;
    }

    static boolean assertValueRepresentation(AnyValue[] values, ValueRepresentation representation) {
        ValueRepresentation actual = null;
        for (AnyValue value : values) {
            actual = actual == null ? value.valueRepresentation() : actual.coerce(value.valueRepresentation());
        }
        return Objects.requireNonNullElse(actual, ValueRepresentation.UNKNOWN) == representation;
    }
}

