/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.utils;

import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.Values;

public final class ValueMath {
    public static final int HASH_CONSTANT = 31;

    private ValueMath() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static LongValue add(long a, long b) {
        return Values.longValue(Math.addExact(a, b));
    }

    public static NumberValue overflowSafeAdd(NumberValue a, NumberValue b) {
        if (a instanceof IntegralValue && b instanceof IntegralValue) {
            return ValueMath.overflowSafeAdd(a.longValue(), b.longValue());
        }
        return a.plus(b);
    }

    public static NumberValue overflowSafeAdd(long a, long b) {
        long r = a + b;
        if (((a ^ r) & (b ^ r)) < 0L) {
            return Values.doubleValue((double)a + (double)b);
        }
        return Values.longValue(r);
    }

    public static DoubleValue add(double a, double b) {
        return Values.doubleValue(a + b);
    }

    public static LongValue subtract(long a, long b) {
        return Values.longValue(Math.subtractExact(a, b));
    }

    public static NumberValue overflowSafeSubtract(long a, long b) {
        long r = a - b;
        if (((a ^ b) & (a ^ r)) < 0L) {
            return Values.doubleValue((double)a - (double)b);
        }
        return Values.longValue(r);
    }

    public static DoubleValue subtract(double a, double b) {
        return Values.doubleValue(a - b);
    }

    public static LongValue multiply(long a, long b) {
        return Values.longValue(Math.multiplyExact(a, b));
    }

    public static NumberValue overflowSafeMultiply(long a, long b) {
        long ab;
        long r = a * b;
        long aa = Math.abs(a);
        if ((aa | (ab = Math.abs(b))) >>> 31 != 0L && (b != 0L && r / b != a || a == Long.MIN_VALUE && b == -1L)) {
            return Values.doubleValue((double)a * (double)b);
        }
        return Values.longValue(r);
    }

    public static DoubleValue multiply(double a, double b) {
        return Values.doubleValue(a * b);
    }

    private static boolean oppositeInfinites(double a, double b) {
        return a == Double.POSITIVE_INFINITY && b == Double.NEGATIVE_INFINITY || a == Double.NEGATIVE_INFINITY && b == Double.POSITIVE_INFINITY;
    }

    public static NumberValue incrementalAverage(NumberValue runningAverage, NumberValue newNumber, double weight) {
        double newDbl = newNumber.doubleValue();
        double runningDbl = runningAverage.doubleValue();
        if (Double.isNaN(runningDbl) || Double.isNaN(newDbl)) {
            return Values.NaN;
        }
        boolean newInfinite = Double.isInfinite(newDbl);
        boolean runningInfinite = Double.isInfinite(runningDbl);
        if (!newInfinite && !runningInfinite) {
            NumberValue diff = newNumber.minus(runningAverage);
            NumberValue next = diff.dividedBy(weight);
            return ValueMath.overflowSafeAdd(runningAverage, next);
        }
        if (newInfinite && !runningInfinite) {
            return newNumber;
        }
        if (!newInfinite) {
            return runningAverage;
        }
        if (ValueMath.oppositeInfinites(newDbl, runningDbl)) {
            return Values.NaN;
        }
        return runningAverage;
    }
}

