/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.ValueWriter;

public final class DoubleValue
extends FloatingPointValue {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(DoubleValue.class);
    private final double value;

    DoubleValue(double value) {
        this.value = value;
    }

    public double value() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeFloatingPoint(this.value);
    }

    @Override
    public Double asObjectCopy() {
        return this.value;
    }

    @Override
    public String prettyPrint() {
        return Double.toString(this.value);
    }

    public String toString() {
        return String.format("%s(%e)", this.getTypeName(), this.value);
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapDouble(this);
    }

    @Override
    public String getTypeName() {
        return "Double";
    }

    public long estimatedHeapUsage() {
        return SHALLOW_SIZE;
    }

    @Override
    public ValueRepresentation valueRepresentation() {
        return ValueRepresentation.FLOAT64;
    }
}

