/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.util.Arrays;
import java.util.TimeZone;
import org.neo4j.internal.helpers.Format;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.AbstractLogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;

public class LogEntryStart
extends AbstractLogEntry {
    private final long timeWritten;
    private final long lastCommittedTxWhenTransactionStarted;
    private final int previousChecksum;
    private final byte[] additionalHeader;
    private LogPosition startPosition;

    public LogEntryStart(long timeWritten, long lastCommittedTxWhenTransactionStarted, int previousChecksum, byte[] additionalHeader, LogPosition startPosition) {
        this(LogEntryVersion.LATEST_VERSION, timeWritten, lastCommittedTxWhenTransactionStarted, previousChecksum, additionalHeader, startPosition);
    }

    public LogEntryStart(LogEntryVersion version, long timeWritten, long lastCommittedTxWhenTransactionStarted, int previousChecksum, byte[] additionalHeader, LogPosition startPosition) {
        super(version, (byte)1);
        this.previousChecksum = previousChecksum;
        this.startPosition = startPosition;
        this.timeWritten = timeWritten;
        this.lastCommittedTxWhenTransactionStarted = lastCommittedTxWhenTransactionStarted;
        this.additionalHeader = additionalHeader;
    }

    public LogPosition getStartPosition() {
        return this.startPosition;
    }

    public long getTimeWritten() {
        return this.timeWritten;
    }

    public long getLastCommittedTxWhenTransactionStarted() {
        return this.lastCommittedTxWhenTransactionStarted;
    }

    public byte[] getAdditionalHeader() {
        return this.additionalHeader;
    }

    public String toString() {
        return this.toString(Format.DEFAULT_TIME_ZONE);
    }

    @Override
    public String toString(TimeZone timeZone) {
        return "Start[time=" + this.timestamp(this.timeWritten, timeZone) + ",lastCommittedTxWhenTransactionStarted=" + this.lastCommittedTxWhenTransactionStarted + ",previousChecksum=" + this.previousChecksum + ",additionalHeaderLength=" + (this.additionalHeader == null ? -1 : this.additionalHeader.length) + "," + (this.additionalHeader == null ? "" : Arrays.toString(this.additionalHeader)) + ",position=" + this.startPosition + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogEntryStart start = (LogEntryStart)o;
        return this.lastCommittedTxWhenTransactionStarted == start.lastCommittedTxWhenTransactionStarted && this.timeWritten == start.timeWritten && this.previousChecksum == start.previousChecksum && Arrays.equals(this.additionalHeader, start.additionalHeader) && this.startPosition.equals(start.startPosition);
    }

    public int hashCode() {
        int result = (int)(this.timeWritten ^ this.timeWritten >>> 32);
        result = 31 * result + (int)(this.lastCommittedTxWhenTransactionStarted ^ this.lastCommittedTxWhenTransactionStarted >>> 32);
        result = 31 * result + this.previousChecksum;
        result = 31 * result + (this.additionalHeader != null ? Arrays.hashCode(this.additionalHeader) : 0);
        result = 31 * result + this.startPosition.hashCode();
        return result;
    }

    public int getPreviousChecksum() {
        return this.previousChecksum;
    }
}

