/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.util.Arrays;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.AbstractVersionAwareLogEntry;
import org.neo4j.string.Mask;

public class LogEntryStart
extends AbstractVersionAwareLogEntry {
    protected final long timeWritten;
    protected final long lastCommittedTxWhenTransactionStarted;
    protected final byte[] additionalHeader;
    protected final LogPosition startPosition;

    protected LogEntryStart(KernelVersion kernelVersion, long timeWritten, long lastCommittedTxWhenTransactionStarted, byte[] additionalHeader, LogPosition startPosition) {
        super(kernelVersion, (byte)1);
        this.startPosition = startPosition;
        this.timeWritten = timeWritten;
        this.lastCommittedTxWhenTransactionStarted = lastCommittedTxWhenTransactionStarted;
        this.additionalHeader = additionalHeader;
    }

    public LogPosition getStartPosition() {
        return this.startPosition;
    }

    public long getTimeWritten() {
        return this.timeWritten;
    }

    public long getLastCommittedTxWhenTransactionStarted() {
        return this.lastCommittedTxWhenTransactionStarted;
    }

    public byte[] getAdditionalHeader() {
        return this.additionalHeader;
    }

    public int getPreviousChecksum() {
        return 0;
    }

    public String toString(Mask mask) {
        return "Start[kernelVersion=" + this.kernelVersion() + ",time=" + this.timestamp(this.timeWritten) + ",lastCommittedTxWhenTransactionStarted=" + this.lastCommittedTxWhenTransactionStarted + ",additionalHeaderLength=" + (this.additionalHeader == null ? -1 : this.additionalHeader.length) + "," + (this.additionalHeader == null ? "" : Arrays.toString(this.additionalHeader)) + ",position=" + this.startPosition + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogEntryStart start = (LogEntryStart)o;
        return this.lastCommittedTxWhenTransactionStarted == start.lastCommittedTxWhenTransactionStarted && this.timeWritten == start.timeWritten && this.kernelVersion() == start.kernelVersion() && Arrays.equals(this.additionalHeader, start.additionalHeader) && this.startPosition.equals((Object)start.startPosition);
    }

    public int hashCode() {
        int result = (int)(this.timeWritten ^ this.timeWritten >>> 32);
        result = 31 * result + (int)(this.lastCommittedTxWhenTransactionStarted ^ this.lastCommittedTxWhenTransactionStarted >>> 32);
        result = 31 * result + (this.additionalHeader != null ? Arrays.hashCode(this.additionalHeader) : 0);
        result = 31 * result + this.startPosition.hashCode();
        return result;
    }
}

