/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.v42;

import java.io.IOException;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializer;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.v42.LogEntryStartV4_2;
import org.neo4j.storageengine.api.CommandReaderFactory;

public class StartLogEntrySerializerV4_2
extends LogEntrySerializer<LogEntryStart> {
    public StartLogEntrySerializerV4_2() {
        super((byte)1);
    }

    @Override
    public LogEntryStart parse(KernelVersion version, ReadableChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory) throws IOException {
        LogPosition position = marker.newPosition();
        long timeWritten = channel.getLong();
        long latestCommittedTxWhenStarted = channel.getLong();
        int previousChecksum = channel.getInt();
        int additionalHeaderLength = channel.getInt();
        byte[] additionalHeader = new byte[additionalHeaderLength];
        channel.get(additionalHeader, additionalHeaderLength);
        return new LogEntryStartV4_2(version, timeWritten, latestCommittedTxWhenStarted, previousChecksum, additionalHeader, position);
    }

    @Override
    public int write(WritableChannel channel, LogEntryStart logEntry) throws IOException {
        channel.beginChecksumForWriting();
        StartLogEntrySerializerV4_2.writeLogEntryHeader(logEntry.kernelVersion(), (byte)1, channel);
        byte[] additionalHeaderData = logEntry.getAdditionalHeader();
        channel.putLong(logEntry.getTimeWritten()).putLong(logEntry.getLastCommittedTxWhenTransactionStarted()).putInt(logEntry.getPreviousChecksum()).putInt(additionalHeaderData.length).put(additionalHeaderData, additionalHeaderData.length);
        return 0;
    }
}

