/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.v42;

import java.util.Arrays;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.string.Mask;

public class LogEntryStartV4_2
extends LogEntryStart {
    private final int previousChecksum;

    public LogEntryStartV4_2(KernelVersion version, long timeWritten, long lastCommittedTxWhenTransactionStarted, int previousChecksum, byte[] additionalHeader, LogPosition startPosition) {
        super(version, timeWritten, lastCommittedTxWhenTransactionStarted, additionalHeader, startPosition);
        this.previousChecksum = previousChecksum;
    }

    @Override
    public int getPreviousChecksum() {
        return this.previousChecksum;
    }

    @Override
    public String toString(Mask mask) {
        return "Start[kernelVersion=" + String.valueOf(this.kernelVersion()) + ",time=" + this.timestamp(this.timeWritten) + ",lastCommittedTxWhenTransactionStarted=" + this.lastCommittedTxWhenTransactionStarted + ",additionalHeaderLength=" + (this.additionalHeader == null ? -1 : this.additionalHeader.length) + "," + (this.additionalHeader == null ? "" : Arrays.toString(this.additionalHeader)) + ",previousChecksum=" + this.previousChecksum + ",position=" + String.valueOf(this.startPosition) + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogEntryStartV4_2 start = (LogEntryStartV4_2)o;
        return this.lastCommittedTxWhenTransactionStarted == start.lastCommittedTxWhenTransactionStarted && this.timeWritten == start.timeWritten && this.previousChecksum == start.previousChecksum && Arrays.equals(this.additionalHeader, start.additionalHeader) && this.startPosition.equals((Object)start.startPosition);
    }

    @Override
    public int hashCode() {
        int result = (int)(this.timeWritten ^ this.timeWritten >>> 32);
        result = 31 * result + (int)(this.lastCommittedTxWhenTransactionStarted ^ this.lastCommittedTxWhenTransactionStarted >>> 32);
        result = 31 * result + this.previousChecksum;
        result = 31 * result + (this.additionalHeader != null ? Arrays.hashCode(this.additionalHeader) : 0);
        result = 31 * result + this.startPosition.hashCode();
        return result;
    }
}

