/*
 * Decompiled with CFR 0.152.
 */
package apoc.algo;

import apoc.stats.DegreeUtil;
import java.util.Arrays;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelectionCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.kernel.api.KernelTransaction;

public class CoreGraphAlgorithms {
    private final KernelTransaction ktx;
    private final Read read;
    private final CursorFactory cursors;
    private int nodeCount;
    private int relCount;
    private int[] nodeRelOffsets;
    private int[] rels;
    public static final float ALPHA = 0.15f;
    private int labelId;
    private int relTypeId;

    private long spreadBits32(int y) {
        long x = y;
        x = (x | x << 32) & 0xFFFFFFFFL;
        x = (x | x << 16) & 0xFFFF0000FFFFL;
        x = (x | x << 8) & 0xFF00FF00FF00FFL;
        x = (x | x << 4) & 0xF0F0F0F0F0F0F0FL;
        x = (x | x << 2) & 0x3333333333333333L;
        x = (x | x << 1) & 0x5555555555555555L;
        return x;
    }

    private long interleave64(int x, int y) {
        return this.spreadBits32(x) | this.spreadBits32(y) << 1;
    }

    private int encode(int x, int y, int r) {
        int mask = (1 << r) - 1;
        int hodd = 0;
        int heven = x ^ y;
        int notx = ~x & mask;
        int noty = ~y & mask;
        int temp = notx ^ y;
        int v0 = 0;
        int v1 = 0;
        for (int k = 1; k < r; ++k) {
            v1 = (v1 & heven | (v0 ^ noty) & temp) >> 1;
            v0 = (v0 & (v1 ^ notx) | ~v0 & (v1 ^ noty)) >> 1;
        }
        hodd = ~v0 & (v1 ^ x) | v0 & (v1 ^ noty);
        return CoreGraphAlgorithms.interleaveBits(hodd, heven);
    }

    private static int interleaveBits(int odd, int even) {
        int val = 0;
        int n = 0;
        for (int max = Math.max(odd, even); max > 0; max >>= 1) {
            ++n;
        }
        for (int i = 0; i < n; ++i) {
            int bitMask = 1 << i;
            int a = (even & bitMask) > 0 ? 1 << 2 * i : 0;
            int b = (odd & bitMask) > 0 ? 1 << 2 * i + 1 : 0;
            val += a + b;
        }
        return val;
    }

    int xy2d(int n, int x, int y) {
        int[] xy = new int[2];
        int d = 0;
        for (int s = n >> 1; s != 0; s >>= 1) {
            int rx = (x & s) != 0 ? 1 : 0;
            int ry = (y & s) != 0 ? 1 : 0;
            d += s * s * (3 * rx ^ ry);
            xy[0] = x;
            xy[1] = y;
            this.rot(s, xy, rx, ry);
        }
        return d;
    }

    void d2xy(int n, int d, int[] xy) {
        int t = d;
        xy[0] = 0;
        xy[1] = 0;
        for (int s = 1; s != n; s <<= 1) {
            int rx = 1 & t >> 1;
            int ry = 1 & (t ^ rx);
            this.rot(s, xy, rx, ry);
            xy[0] = xy[0] + s * rx;
            xy[1] = xy[1] + s * ry;
            t /= 4;
        }
    }

    void rot(int n, int[] xy, int rx, int ry) {
        if (ry == 0) {
            if (rx == 1) {
                xy[0] = n - 1 - xy[0];
                xy[1] = n - 1 - xy[1];
            }
            int t = xy[0];
            xy[0] = xy[1];
            xy[1] = t;
        }
    }

    public static int toInt(double value) {
        return (int)(100000.0 * value);
    }

    public static double toFloat(int value) {
        return (double)value / 100000.0;
    }

    private int[] loadNodes(int size, int relType, Direction direction) {
        CursorFactory cursors = this.ktx.cursors();
        try (NodeCursor node = cursors.allocateNodeCursor();){
            int[] offsets = new int[size];
            Arrays.fill(offsets, -1);
            int offset = 0;
            int maxIdx = 0;
            this.ktx.dataRead().allNodesScan(node);
            while (node.next()) {
                int degree = DegreeUtil.degree(node, cursors, relType, direction);
                int idx = CoreGraphAlgorithms.mapId(node.nodeReference());
                offsets[idx] = offset;
                offset += degree;
                if (idx <= maxIdx) continue;
                maxIdx = idx;
            }
            int[] nArray = maxIdx < offsets.length - 1 ? Arrays.copyOf(offsets, maxIdx + 1) : offsets;
            return nArray;
        }
    }

    public int[] loadDegrees(String relName, Direction direction) {
        int relType = relName == null ? -1 : this.ktx.tokenRead().relationshipType(relName);
        return this.loadDegrees(relType, direction);
    }

    private int[] loadDegrees(int relType, Direction direction) {
        try (NodeCursor nodeCursor = this.cursors.allocateNodeCursor();){
            int[] degrees = new int[this.nodeCount];
            for (int nodeIdx = 0; nodeIdx < this.nodeCount; ++nodeIdx) {
                long nodeId = CoreGraphAlgorithms.unMapId(nodeIdx);
                this.read.singleNode(nodeId, nodeCursor);
                degrees[nodeIdx] = nodeCursor.next() ? DegreeUtil.degree(nodeCursor, this.cursors, relType, direction) : -1;
            }
            int[] nArray = degrees;
            return nArray;
        }
    }

    /*
     * Exception decompiling
     */
    private int[] loadNodesForLabel(int labelId, int nodeCount, int relTypeId, Direction direction) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void runProgram(RelationshipProgram consumer) {
        CoreGraphAlgorithms.runProgram(this.nodeCount, this.nodeRelOffsets, this.rels, consumer);
    }

    private static void runProgram(int nodeCount, int[] offsets, int[] rels, RelationshipProgram consumer) {
        for (int start = 0; start < nodeCount; ++start) {
            int end;
            int nextOffset;
            int offset = offsets[start];
            if (offset == -1) continue;
            int n = nextOffset = start + 1 == nodeCount ? rels.length : offsets[start + 1];
            while (offset != nextOffset && (end = rels[offset]) != -1) {
                consumer.accept(start, end);
                ++offset;
            }
        }
    }

    public float[] pageRank(int iterations) {
        float oneMinusAlpha = 0.85f;
        int[] degrees = this.loadDegrees(this.relTypeId, Direction.OUTGOING);
        float[] dst = new float[this.nodeCount];
        float[] src = new float[this.nodeCount];
        for (int it = 0; it < iterations; ++it) {
            for (int node = 0; node < this.nodeCount; ++node) {
                src[node] = 0.15f * dst[node] / (float)degrees[node];
                dst[node] = oneMinusAlpha;
            }
            this.runProgram((start, end) -> {
                int n = end;
                dst[n] = dst[n] + src[start];
            });
        }
        for (int node = 0; node < this.nodeCount; ++node) {
            if (degrees[node] != 0 || dst[node] != oneMinusAlpha) continue;
            dst[node] = 0.0f;
        }
        return dst;
    }

    public void pregel(RelationshipProgram program, SuperStep superStep) {
        while (superStep.run()) {
            this.runProgram(program);
        }
    }

    public float[] pageRank2(int iterations) {
        class PageRank
        implements SuperStep,
        RelationshipProgram {
            private int iterations;
            float alpha = 0.15f;
            float oneMinusAlpha = 1.0f - this.alpha;
            float[] dst = new float[CoreGraphAlgorithms.access$000(CoreGraphAlgorithms.this)];
            float[] src = new float[CoreGraphAlgorithms.access$000(CoreGraphAlgorithms.this)];

            public PageRank(int iterations) {
                this.iterations = iterations;
            }

            @Override
            public void accept(int start, int end) {
                int n = end;
                this.dst[n] = this.dst[n] + this.src[start];
            }

            @Override
            public boolean run() {
                for (int node = 0; node < CoreGraphAlgorithms.this.nodeCount; ++node) {
                    this.src[node] = this.alpha * this.dst[node] / (float)CoreGraphAlgorithms.this.nodeRelOffsets[node];
                    this.dst[node] = this.oneMinusAlpha;
                }
                return this.iterations-- > 0;
            }
        }
        PageRank program = new PageRank(iterations);
        this.pregel(program, program);
        return program.dst;
    }

    public int[] labelPropagation() {
        int[] labels = new int[this.nodeCount];
        for (int nodeId = 0; nodeId < this.nodeCount; ++nodeId) {
            labels[nodeId] = nodeId;
        }
        boolean[] done = new boolean[]{false};
        while (!done[0]) {
            done[0] = true;
            this.runProgram((start, end) -> {
                if (labels[start] != labels[end]) {
                    done[0] = false;
                    labels[start] = labels[end] = Math.min(labels[start], labels[end]);
                }
            });
        }
        return labels;
    }

    public int[] unionFind() {
        byte[] rank = new byte[this.nodeCount];
        int[] root = new int[this.nodeCount];
        for (int nodeId = 0; nodeId < this.nodeCount; ++nodeId) {
            root[nodeId] = nodeId;
        }
        this.runProgram((x, y) -> {
            while (x != root[x]) {
                x = root[x];
            }
            while (y != root[y]) {
                y = root[y];
            }
            if (x != y) {
                if (rank[x] >= rank[y]) {
                    root[y] = x;
                    if (rank[x] == rank[y]) {
                        int n = x;
                        rank[n] = (byte)(rank[n] + 1);
                    }
                } else {
                    root[x] = y;
                }
            }
        });
        return root;
    }

    private static int mapId(long id) {
        return (int)id;
    }

    private static long unMapId(int id) {
        return id;
    }

    public CoreGraphAlgorithms(KernelTransaction ktx) {
        this.ktx = ktx;
        this.read = ktx.dataRead();
        this.cursors = ktx.cursors();
    }

    private void loadRels(int labelId, int relTypeId) {
        this.relCount = (int)this.read.countsForRelationshipWithoutTxState(labelId, relTypeId, -1);
        this.rels = new int[this.relCount];
        try (NodeLabelIndexCursor nodeLabelIndexCursor = this.cursors.allocateNodeLabelIndexCursor();
             NodeCursor nodeCursor = this.cursors.allocateNodeCursor();){
            int[] nArray;
            int idx = 0;
            if (relTypeId == -1) {
                nArray = null;
            } else {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = relTypeId;
            }
            int[] relTypes = nArray;
            if (labelId == -1) {
                this.read.allNodesScan(nodeCursor);
                while (nodeCursor.next()) {
                    idx = this.loadRelsForNode(nodeCursor, idx, relTypes);
                }
            } else {
                this.read.nodeLabelScan(labelId, nodeLabelIndexCursor);
                while (nodeLabelIndexCursor.next()) {
                    nodeLabelIndexCursor.node(nodeCursor);
                    if (!nodeCursor.next()) {
                        throw new IllegalArgumentException("could not position cursor");
                    }
                    idx = this.loadRelsForNode(nodeCursor, idx, relTypes);
                }
            }
        }
    }

    private int loadRelsForNode(NodeCursor nodeCursor, int idx, int[] relTypes) {
        RelationshipSelectionCursor relationshipSelectionCursor = RelationshipSelections.outgoingCursor((CursorFactory)this.cursors, (NodeCursor)nodeCursor, (int[])relTypes);
        while (relationshipSelectionCursor.next()) {
            this.rels[idx++] = CoreGraphAlgorithms.mapId(relationshipSelectionCursor.otherNodeReference());
        }
        return idx;
    }

    private void loadNodes(int labelId, int relTypeId) {
        this.labelId = labelId;
        this.relTypeId = relTypeId;
        int allNodeCount = (int)this.ktx.dataRead().nodesGetCount();
        if (labelId == -1) {
            this.nodeRelOffsets = this.loadNodes(allNodeCount, relTypeId, Direction.OUTGOING);
            this.nodeCount = this.nodeRelOffsets.length;
        } else {
            this.nodeCount = (int)this.ktx.dataRead().countsForNodeWithoutTxState(labelId);
            float percentage = (float)this.nodeCount / (float)allNodeCount;
            this.nodeRelOffsets = percentage > 0.5f ? this.loadNodesForLabel(labelId, this.nodeCount, relTypeId, Direction.OUTGOING) : this.loadNodes(allNodeCount, relTypeId, Direction.OUTGOING);
        }
    }

    public CoreGraphAlgorithms init(String label) {
        int labelId = this.ktx.tokenRead().nodeLabel(label);
        this.loadNodes(labelId, -1);
        this.loadRels(labelId, -1);
        return this;
    }

    public CoreGraphAlgorithms init(String label, String rel) {
        TokenRead token = this.ktx.tokenRead();
        int labelId = token.nodeLabel(label);
        int relTypeId = token.relationshipType(rel);
        this.loadNodes(labelId, relTypeId);
        this.loadRels(labelId, relTypeId);
        return this;
    }

    public CoreGraphAlgorithms init() {
        this.loadNodes(-1, -1);
        this.loadRels(-1, -1);
        return this;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public int getRelCount() {
        return this.relCount;
    }

    public int[] getNodeRelOffsets() {
        return this.nodeRelOffsets;
    }

    public int[] getRels() {
        return this.rels;
    }

    static interface SuperStep {
        public boolean run();
    }

    static interface RelationshipProgram {
        public void accept(int var1, int var2);
    }
}

